/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.convert;

import com.alibaba.fastjson.serializer.ValueFilter;
import java.lang.reflect.Field;
import org.minbox.framework.api.boot.convert.annotation.ApiBootValueHide;

public class ValueHideFilter
implements ValueFilter {
    public Object process(Object object, String name, Object value) {
        if (object != null) {
            try {
                Field field = object.getClass().getDeclaredField(name);
                if (field.isAnnotationPresent(ApiBootValueHide.class)) {
                    ApiBootValueHide valueHide = field.getDeclaredAnnotation(ApiBootValueHide.class);
                    if (valueHide.length() <= 0) {
                        return object;
                    }
                    String fieldValue = String.valueOf(value);
                    char[] chars = fieldValue.toCharArray();
                    if (valueHide.start() > 0) {
                        return this.startHide(valueHide, chars);
                    }
                    return this.positionHide(valueHide, chars);
                }
            }
            catch (Exception e) {
                return value;
            }
        }
        return value;
    }

    String startHide(ApiBootValueHide valueHide, char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (valueHide.start() - 1 > i || i >= valueHide.start() + valueHide.length() - 1) continue;
            chars[i] = valueHide.placeholder().charAt(0);
        }
        return new String(chars);
    }

    String positionHide(ApiBootValueHide valueHide, char[] chars) {
        block5: for (int i = 0; i < chars.length; ++i) {
            switch (valueHide.position()) {
                case START: {
                    if (i >= valueHide.length()) continue block5;
                    chars[i] = valueHide.placeholder().charAt(0);
                    continue block5;
                }
                case MIDDLE: {
                    int startPosition = chars.length / 2;
                    if (i < startPosition - 1 || i >= startPosition - 1 + valueHide.length()) continue block5;
                    chars[i] = valueHide.placeholder().charAt(0);
                    continue block5;
                }
                case END: {
                    if (i < chars.length - valueHide.length()) continue block5;
                    chars[i] = valueHide.placeholder().charAt(0);
                }
            }
        }
        return new String(chars);
    }
}

