/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.push.support;

import java.util.Map;
import org.minbox.framework.api.boot.common.exception.ApiBootException;
import org.minbox.framework.api.boot.push.ApiBootMessagePushService;
import org.minbox.framework.api.boot.push.aop.holder.MessagePushContextHolder;
import org.minbox.framework.api.boot.push.model.PushClientConfig;
import org.minbox.framework.api.boot.push.support.ApiBootMessagePushJiGuangServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class ApiBootAbstractMessagePushServiceImpl
implements ApiBootMessagePushService {
    static Logger logger = LoggerFactory.getLogger(ApiBootMessagePushJiGuangServiceImpl.class);
    static final String DEFAULT_CLIENT_NAME = "default";
    private Map<String, PushClientConfig> pushClientConfigs;
    private boolean production;

    public ApiBootAbstractMessagePushServiceImpl(Map<String, PushClientConfig> pushClientConfigs, boolean production) {
        this.pushClientConfigs = pushClientConfigs;
        this.production = production;
    }

    @Override
    public String getCurrentPushClientName() throws ApiBootException {
        String clientName = MessagePushContextHolder.get();
        logger.debug("Use [{}] push message client", (Object)clientName);
        return StringUtils.isEmpty((Object)clientName) ? DEFAULT_CLIENT_NAME : clientName;
    }

    @Override
    public PushClientConfig getCurrentPushClient() throws ApiBootException {
        String currentClientName = this.getCurrentPushClientName();
        return this.pushClientConfigs.get(currentClientName);
    }

    public boolean isProduction() {
        return this.production;
    }
}

