/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.push.support;

import cn.jiguang.common.ClientConfig;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosAlert;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import java.util.List;
import java.util.Map;
import org.minbox.framework.api.boot.common.exception.ApiBootException;
import org.minbox.framework.api.boot.push.model.MessagePushBody;
import org.minbox.framework.api.boot.push.model.PushClientConfig;
import org.minbox.framework.api.boot.push.support.ApiBootAbstractMessagePushServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class ApiBootMessagePushJiGuangServiceImpl
extends ApiBootAbstractMessagePushServiceImpl {
    static Logger logger = LoggerFactory.getLogger(ApiBootMessagePushJiGuangServiceImpl.class);

    public ApiBootMessagePushJiGuangServiceImpl(Map<String, PushClientConfig> pushClientConfigs, boolean production) {
        super(pushClientConfigs, production);
    }

    @Override
    public void executePush(MessagePushBody messagePushBody) throws ApiBootException {
        try {
            PushClientConfig pushClientConfig = this.getCurrentPushClient();
            JPushClient pushClient = new JPushClient(pushClientConfig.getMasterSecret(), pushClientConfig.getAppKey(), null, ClientConfig.getInstance());
            PushPayload.Builder builder = PushPayload.newBuilder();
            this.addPlatformMeta(messagePushBody, builder);
            this.addTagMeta(messagePushBody, builder);
            this.addAliasMeta(messagePushBody.getAlias(), builder);
            this.addNotificationMeta(builder, messagePushBody);
            pushClient.sendPush(builder.build());
        }
        catch (Exception e) {
            logger.error("Execute push message fail.", (Throwable)e);
        }
    }

    private void addPlatformMeta(MessagePushBody messagePushBody, PushPayload.Builder builder) {
        switch (messagePushBody.getPlatform()) {
            case ALL: {
                builder.setPlatform(Platform.all());
                break;
            }
            case IOS: {
                builder.setPlatform(Platform.ios());
                builder.setOptions(Options.newBuilder().setApnsProduction(this.isProduction()).build());
                break;
            }
            case ANDROID: {
                builder.setPlatform(Platform.android());
                break;
            }
            default: {
                builder.setPlatform(Platform.all());
            }
        }
    }

    private void addAliasMeta(List<String> alias, PushPayload.Builder builder) {
        if (!ObjectUtils.isEmpty(alias)) {
            builder.setAudience(Audience.alias(alias));
        }
    }

    private void addTagMeta(MessagePushBody messagePushBody, PushPayload.Builder builder) {
        if (!ObjectUtils.isEmpty(messagePushBody.getTags())) {
            builder.setAudience(Audience.tag(messagePushBody.getTags()));
        }
    }

    private void addNotificationMeta(PushPayload.Builder builder, MessagePushBody messagePushBody) {
        Notification notification = null;
        switch (messagePushBody.getPlatform()) {
            case ALL: {
                notification = Notification.newBuilder().addPlatformNotification(this.getIosNotificationMeta(messagePushBody)).addPlatformNotification(this.getAndroidNotificationMeta(messagePushBody)).build();
                break;
            }
            case IOS: {
                notification = Notification.newBuilder().addPlatformNotification(this.getIosNotificationMeta(messagePushBody)).build();
                break;
            }
            case ANDROID: {
                notification = Notification.newBuilder().addPlatformNotification(this.getAndroidNotificationMeta(messagePushBody)).build();
            }
        }
        builder.setNotification(notification);
    }

    private PlatformNotification getIosNotificationMeta(MessagePushBody messagePushBody) {
        IosNotification.Builder builder = IosNotification.newBuilder().setAlert((Object)IosAlert.newBuilder().setTitleAndBody(messagePushBody.getTitle(), messagePushBody.getSubTitle(), messagePushBody.getMessage()).build()).setBadge(messagePushBody.getBadge()).setSound((Object)messagePushBody.getSound());
        if (!ObjectUtils.isEmpty(messagePushBody.getExtras())) {
            builder.addExtras(messagePushBody.getExtras());
        }
        return builder.build();
    }

    private PlatformNotification getAndroidNotificationMeta(MessagePushBody messagePushBody) {
        return ((AndroidNotification.Builder)AndroidNotification.newBuilder().setTitle(messagePushBody.getTitle()).setAlert((Object)messagePushBody.getMessage()).addExtras(messagePushBody.getExtras())).build();
    }
}

