/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.quartz.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.minbox.framework.api.boot.quartz.ApiBootQuartzService;
import org.minbox.framework.api.boot.quartz.wrapper.ApiBootJobWrapper;
import org.minbox.framework.api.boot.quartz.wrapper.support.ApiBootCronJobWrapper;
import org.minbox.framework.api.boot.quartz.wrapper.support.ApiBootLoopJobWrapper;
import org.minbox.framework.api.boot.quartz.wrapper.support.ApiBootOnceJobWrapper;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ApiBootQuartzServiceDefaultSupport
implements ApiBootQuartzService {
    static Logger logger = LoggerFactory.getLogger(ApiBootQuartzServiceDefaultSupport.class);
    private Scheduler scheduler;

    public ApiBootQuartzServiceDefaultSupport(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Scheduler getScheduler() throws SchedulerException {
        return this.scheduler;
    }

    @Override
    public String newJob(ApiBootJobWrapper jobWrapper) {
        try {
            if (ObjectUtils.isEmpty((Object)jobWrapper)) {
                throw new SchedulerException("When creating a new task, parameters must be passed.");
            }
            if (StringUtils.isEmpty((Object)jobWrapper.getJobKey())) {
                jobWrapper.setJobKey(UUID.randomUUID().toString());
            }
            if (jobWrapper instanceof ApiBootCronJobWrapper) {
                this.newCronJob((ApiBootCronJobWrapper)jobWrapper);
            } else if (jobWrapper instanceof ApiBootLoopJobWrapper) {
                this.newLoopJob((ApiBootLoopJobWrapper)jobWrapper);
            } else if (jobWrapper instanceof ApiBootOnceJobWrapper) {
                this.newOnceJob((ApiBootOnceJobWrapper)jobWrapper);
            }
        }
        catch (Exception e) {
            logger.error("Create new job error.", (Throwable)e);
        }
        return jobWrapper.getJobKey();
    }

    @Override
    public void deleteJob(String jobKey) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobKey);
            this.scheduler.pauseTrigger(triggerKey);
            this.scheduler.unscheduleJob(triggerKey);
            this.scheduler.deleteJob(JobKey.jobKey((String)jobKey));
        }
        catch (Exception e) {
            logger.error("I encountered some problems while deleting the job", (Throwable)e);
        }
    }

    @Override
    public void deleteJobs(String ... jobKeys) {
        if (!ObjectUtils.isEmpty((Object[])jobKeys)) {
            Arrays.stream(jobKeys).forEach(jobKey -> this.deleteJob((String)jobKey));
        }
    }

    @Override
    public void deleteJobs(Collection<String> jobKeys) {
        if (!ObjectUtils.isEmpty(jobKeys)) {
            jobKeys.forEach(jobKey -> this.deleteJob((String)jobKey));
        }
    }

    @Override
    public void pauseJob(String jobKey) {
        try {
            this.scheduler.pauseJob(JobKey.jobKey((String)jobKey));
        }
        catch (Exception e) {
            logger.error("I encountered some problems while pausing the job", (Throwable)e);
        }
    }

    @Override
    public void pauseJobs(String ... jobKeys) {
        if (!ObjectUtils.isEmpty((Object[])jobKeys)) {
            Arrays.stream(jobKeys).forEach(jobKey -> this.pauseJob((String)jobKey));
        }
    }

    @Override
    public void pauseJobs(Collection<String> jobKeys) {
        if (!ObjectUtils.isEmpty(jobKeys)) {
            jobKeys.forEach(jobKey -> this.pauseJob((String)jobKey));
        }
    }

    @Override
    public void resumeJob(String jobKey) {
        try {
            this.scheduler.resumeJob(JobKey.jobKey((String)jobKey));
        }
        catch (Exception e) {
            logger.error("I encountered some problems when resuming a suspended job", (Throwable)e);
        }
    }

    @Override
    public void resumeJobs(String ... jobKeys) {
        if (!ObjectUtils.isEmpty((Object[])jobKeys)) {
            Arrays.stream(jobKeys).forEach(jobKey -> this.resumeJob((String)jobKey));
        }
    }

    @Override
    public void resumeJobs(Collection<String> jobKeys) {
        if (!ObjectUtils.isEmpty(jobKeys)) {
            jobKeys.forEach(jobKey -> this.resumeJob((String)jobKey));
        }
    }

    @Override
    public void updateJobCron(String jobKey, String cron) {
        try {
            CronTrigger cronTrigger = (CronTrigger)this.getTrigger(jobKey);
            if (!cronTrigger.getCronExpression().equals(cron)) {
                TriggerKey triggerKey = TriggerKey.triggerKey((String)jobKey);
                cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).startNow().build();
                this.scheduler.rescheduleJob(triggerKey, (Trigger)cronTrigger);
            }
        }
        catch (Exception e) {
            logger.error("Update job cron error.", (Throwable)e);
        }
    }

    @Override
    public void updateJobStartTime(String jobKey, Date jobStartTime) {
        try {
            Trigger trigger = this.getTrigger(jobKey);
            trigger = TriggerBuilder.newTrigger().withIdentity(trigger.getKey()).withSchedule(trigger.getScheduleBuilder()).startAt(jobStartTime).build();
            this.scheduler.rescheduleJob(trigger.getKey(), trigger);
        }
        catch (Exception e) {
            logger.error("Update job start time error", (Throwable)e);
        }
    }

    @Override
    public void startAllJobs() throws SchedulerException {
        this.scheduler.start();
    }

    @Override
    public void shutdownAllJobs() throws SchedulerException {
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
    }

    protected Trigger getTrigger(String triggerKeyName) throws SchedulerException {
        Trigger trigger = this.scheduler.getTrigger(TriggerKey.triggerKey((String)triggerKeyName));
        if (ObjectUtils.isEmpty((Object)trigger)) {
            throw new SchedulerException("Unable to get " + triggerKeyName + " information for task trigger");
        }
        return trigger;
    }

    protected JobDetail getJobDetail(String jobKey) throws SchedulerException {
        JobDetail jobDetail = this.scheduler.getJobDetail(JobKey.jobKey((String)jobKey));
        if (ObjectUtils.isEmpty((Object)jobDetail)) {
            throw new SchedulerException("Unable to get " + jobKey + " information for task jobDetail");
        }
        return jobDetail;
    }

    protected JobKey newJobKey(String jobKey) throws SchedulerException {
        return JobKey.jobKey((String)jobKey);
    }

    protected JobDetail newJobDetail(ApiBootJobWrapper wrapper) {
        JobDetail jobDetail = JobBuilder.newJob(wrapper.getJobClass()).withIdentity(wrapper.getJobKey()).build();
        if (!ObjectUtils.isEmpty((Object)wrapper.getParam())) {
            jobDetail.getJobDataMap().putAll(wrapper.getParam().getAllParam());
        }
        return jobDetail;
    }

    protected TriggerKey newTriggerKey(String triggerKey) throws SchedulerException {
        return TriggerKey.triggerKey((String)triggerKey);
    }

    protected Date newCronJob(ApiBootCronJobWrapper wrapper) throws SchedulerException {
        TriggerKey triggerKey = this.newTriggerKey(wrapper.getJobKey());
        JobDetail jobDetail = this.newJobDetail(wrapper);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)wrapper.getCron())).build();
        return this.scheduler.scheduleJob(jobDetail, trigger);
    }

    protected Date newLoopJob(ApiBootLoopJobWrapper wrapper) throws SchedulerException {
        TriggerKey triggerKey = this.newTriggerKey(wrapper.getJobKey());
        JobDetail jobDetail = this.newJobDetail(wrapper);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(wrapper.getRepeatTimes()).withIntervalInMilliseconds(wrapper.getLoopIntervalTime().longValue())).startAt(wrapper.getStartAtTime()).build();
        return this.scheduler.scheduleJob(jobDetail, trigger);
    }

    protected Date newOnceJob(ApiBootOnceJobWrapper wrapper) throws SchedulerException {
        TriggerKey triggerKey = this.newTriggerKey(wrapper.getJobKey());
        JobDetail jobDetail = this.newJobDetail(wrapper);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule()).startAt(wrapper.getStartAtTime()).build();
        return this.scheduler.scheduleJob(jobDetail, trigger);
    }
}

