/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.quartz.wrapper.support;

import java.util.Date;
import org.minbox.framework.api.boot.quartz.wrapper.ApiBootJobParamWrapper;
import org.minbox.framework.api.boot.quartz.wrapper.ApiBootJobWrapper;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ApiBootLoopJobWrapper
extends ApiBootJobWrapper {
    private int repeatTimes;
    private Long loopIntervalTime;

    public ApiBootLoopJobWrapper(String jobKey, Class<? extends QuartzJobBean> jobClass, int repeatTimes, Long loopIntervalTime, Date startAtTime, ApiBootJobParamWrapper param) {
        super(jobKey, jobClass, startAtTime, param);
        this.repeatTimes = repeatTimes;
        this.loopIntervalTime = loopIntervalTime;
    }

    public Long getLoopIntervalTime() {
        return this.loopIntervalTime <= 0L ? 1000L : this.loopIntervalTime;
    }

    public int getRepeatTimes() {
        return this.repeatTimes;
    }

    public static ApiBootLoopJobWrapperBuilder Context() {
        return new ApiBootLoopJobWrapperBuilder();
    }

    public static class ApiBootLoopJobWrapperBuilder {
        private String jobKey;
        private Class<? extends QuartzJobBean> jobClass;
        private int repeatTimes;
        private Long loopIntervalTime;
        private Date startAtTime;
        private ApiBootJobParamWrapper param;

        ApiBootLoopJobWrapperBuilder() {
        }

        public ApiBootLoopJobWrapperBuilder jobKey(String jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public ApiBootLoopJobWrapperBuilder jobClass(Class<? extends QuartzJobBean> jobClass) {
            this.jobClass = jobClass;
            return this;
        }

        public ApiBootLoopJobWrapperBuilder repeatTimes(int repeatTimes) {
            this.repeatTimes = repeatTimes;
            return this;
        }

        public ApiBootLoopJobWrapperBuilder loopIntervalTime(Long loopIntervalTime) {
            this.loopIntervalTime = loopIntervalTime;
            return this;
        }

        public ApiBootLoopJobWrapperBuilder startAtTime(Date startAtTime) {
            this.startAtTime = startAtTime;
            return this;
        }

        public ApiBootLoopJobWrapperBuilder param(ApiBootJobParamWrapper param) {
            this.param = param;
            return this;
        }

        public ApiBootLoopJobWrapper wrapper() {
            return new ApiBootLoopJobWrapper(this.jobKey, this.jobClass, this.repeatTimes, this.loopIntervalTime, this.startAtTime, this.param);
        }

        public String toString() {
            return "ApiBootLoopJobWrapper.ApiBootLoopJobWrapperBuilder(jobKey=" + this.jobKey + ", jobClass=" + this.jobClass + ", repeatTimes=" + this.repeatTimes + ", loopIntervalTime=" + this.loopIntervalTime + ", startAtTime=" + this.startAtTime + ", param=" + this.param + ")";
        }
    }
}

