/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.sms;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import javax.annotation.PostConstruct;
import org.minbox.framework.api.boot.common.exception.ApiBootException;
import org.minbox.framework.api.boot.sms.ApiBootSmsService;
import org.minbox.framework.api.boot.sms.request.ApiBootSmsRequest;
import org.minbox.framework.api.boot.sms.response.ApiBootSmsResponse;

public class ApiBootAliYunSmsService
implements ApiBootSmsService {
    private static final String ALIYUN_PRODUCT = "Dysmsapi";
    private static final String ALIYUN_PRODUCT_DOMAIN = "dysmsapi.aliyuncs.com";
    private static final String SUCCESS_RESULT = "OK";
    private String accessKeyId;
    private String accessKeySecret;
    private String signName;
    private String profile;
    private long connectionTimeout;
    private long readTimeout;

    @PostConstruct
    public void _init() {
        System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(this.connectionTimeout));
        System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(this.readTimeout));
    }

    @Override
    public ApiBootSmsResponse send(ApiBootSmsRequest request) throws ApiBootException {
        try {
            DefaultProfile profile = DefaultProfile.getProfile((String)this.profile, (String)this.accessKeyId, (String)this.accessKeySecret);
            DefaultProfile.addEndpoint((String)this.profile, (String)ALIYUN_PRODUCT, (String)ALIYUN_PRODUCT_DOMAIN);
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            SendSmsRequest sendSmsRequest = new SendSmsRequest();
            sendSmsRequest.setPhoneNumbers(request.getPhone());
            sendSmsRequest.setSignName(this.signName);
            sendSmsRequest.setTemplateCode(request.getTemplateCode());
            sendSmsRequest.setTemplateParam(request.getParam().getParamJson());
            SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)sendSmsRequest);
            return ApiBootSmsResponse.builder().success(SUCCESS_RESULT.equals(sendSmsResponse.getCode())).build();
        }
        catch (Exception e) {
            throw new ApiBootException("invoke send SMS have Exception\uff1a" + e.getMessage());
        }
    }

    public ApiBootAliYunSmsService(String accessKeyId, String accessKeySecret, String signName, String profile, long connectionTimeout, long readTimeout) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.signName = signName;
        this.profile = profile;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }
}

