/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.function;

import java.util.Objects;

public abstract class Predicate<T> {
    public abstract boolean test(T var1);

    public Predicate<T> and(final Predicate<T> other) {
        if (other == null || other == this) {
            return this;
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return Predicate.this.test(input) && other.test(input);
            }
        };
    }

    public Predicate<T> or(final Predicate<T> other) {
        if (other == null || other == this) {
            return this;
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return Predicate.this.test(input) || other.test(input);
            }
        };
    }

    public Predicate<T> negate() {
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return !Predicate.this.test(input);
            }

            @Override
            public Predicate<T> negate() {
                return Predicate.this;
            }
        };
    }

    public static <T> Predicate<T> never() {
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return false;
            }
        };
    }

    public static <T> Predicate<T> always() {
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return true;
            }
        };
    }

    public static <T> Predicate<T> isEqual(final Object obj) {
        if (obj == null) {
            return new Predicate<T>(){

                @Override
                public boolean test(T input) {
                    return input == null;
                }
            };
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return Objects.equals(input, obj);
            }
        };
    }
}

