/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific.endpoint.support;

import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.delegate.AbstractSerialDelegatingDefinitionParser;
import org.mule.config.spring.parsers.delegate.AbstractSingleParentFamilyDefinitionParser;
import org.mule.config.spring.parsers.generic.AttributePropertiesDefinitionParser;
import org.mule.config.spring.parsers.processors.BlockAttribute;
import org.mule.config.spring.parsers.processors.CheckExclusiveAttributes;
import org.mule.config.spring.parsers.processors.CheckRequiredAttributes;
import org.mule.config.spring.parsers.specific.endpoint.support.ChildAddressDefinitionParser;
import org.mule.endpoint.URIBuilder;

public class AddressedEndpointDefinitionParser
extends AbstractSingleParentFamilyDefinitionParser {
    public static final boolean META = true;
    public static final boolean PROTOCOL = false;
    public static final String PROPERTIES = "properties";
    public static final String[] RESTRICTED_ENDPOINT_ATTRIBUTES = new String[]{"exchange-pattern", "responseTimeout", "encoding", "connector", "createConnector", "transformer", "responseTransformer", "disableTransportTransformer", "mimeType"};

    public AddressedEndpointDefinitionParser(String protocol, MuleDefinitionParser endpointParser) {
        this(protocol, false, endpointParser);
    }

    public AddressedEndpointDefinitionParser(String metaOrProtocol, boolean isMeta, MuleDefinitionParser endpointParser) {
        this(metaOrProtocol, isMeta, endpointParser, new String[0], new String[0]);
    }

    public AddressedEndpointDefinitionParser(String metaOrProtocol, boolean isMeta, MuleDefinitionParser endpointParser, String[] requiredAddressAttributes, String[] requiredProperties) {
        this(metaOrProtocol, isMeta, endpointParser, RESTRICTED_ENDPOINT_ATTRIBUTES, URIBuilder.ALL_ATTRIBUTES, new String[][]{requiredAddressAttributes}, new String[][]{requiredProperties});
    }

    public AddressedEndpointDefinitionParser(String metaOrProtocol, boolean isMeta, MuleDefinitionParser endpointParser, String[] endpointAttributes, String[] addressAttributes, String[][] requiredAddressAttributes, String[][] requiredProperties) {
        AddressedEndpointDefinitionParser.enableAttributes(endpointParser, endpointAttributes);
        AddressedEndpointDefinitionParser.enableAttribute(endpointParser, "name");
        this.addDelegate(endpointParser);
        AddressParser addressParser = new AddressParser(metaOrProtocol, isMeta, addressAttributes, requiredAddressAttributes);
        this.addHandledException(BlockAttribute.BlockAttributeException.class);
        this.addChildDelegate(addressParser);
        PropertiesParser propertiesParser = new PropertiesParser(PROPERTIES, endpointAttributes, requiredAddressAttributes, requiredProperties);
        this.addChildDelegate(propertiesParser);
    }

    private static class PropertiesParser
    extends AttributePropertiesDefinitionParser {
        public PropertiesParser(String setter, String[] endpointAttributes, String[][] requiredAddressAttributes, String[][] requiredProperties) {
            super(setter);
            AbstractSerialDelegatingDefinitionParser.disableAttributes((MuleDefinitionParser)this, endpointAttributes);
            AbstractSerialDelegatingDefinitionParser.disableAttributes((MuleDefinitionParser)this, URIBuilder.ALL_ATTRIBUTES);
            AbstractSerialDelegatingDefinitionParser.disableAttributes((MuleDefinitionParser)this, requiredAddressAttributes);
            AbstractSerialDelegatingDefinitionParser.disableAttribute(this, "name");
            AbstractSerialDelegatingDefinitionParser.disableAttribute(this, "ref");
            if (null != requiredProperties && requiredProperties.length > 0 && null != requiredProperties[0] && requiredProperties[0].length > 0) {
                String[][] requiredPropertiesSets = new String[requiredProperties.length + 1][];
                requiredPropertiesSets[0] = new String[]{"ref"};
                System.arraycopy(requiredProperties, 0, requiredPropertiesSets, 1, requiredProperties.length);
                this.registerPreProcessor(new CheckRequiredAttributes(requiredPropertiesSets));
            }
        }
    }

    private static class AddressParser
    extends ChildAddressDefinitionParser {
        public AddressParser(String metaOrProtocol, boolean isMeta, String[] addressAttributes, String[][] requiredAddressAttributes) {
            super(metaOrProtocol, isMeta);
            this.registerPreProcessor(new BlockAttribute("ref"));
            AbstractSerialDelegatingDefinitionParser.enableAttributes((MuleDefinitionParser)this, addressAttributes);
            String[][] addressAttributeSets = new String[(null != requiredAddressAttributes ? requiredAddressAttributes.length : 0) + 2][];
            addressAttributeSets[0] = new String[]{"address"};
            addressAttributeSets[1] = new String[]{"ref"};
            if (null != requiredAddressAttributes) {
                AbstractSerialDelegatingDefinitionParser.enableAttributes((MuleDefinitionParser)this, requiredAddressAttributes);
                System.arraycopy(requiredAddressAttributes, 0, addressAttributeSets, 2, requiredAddressAttributes.length);
            }
            this.registerPreProcessor(new CheckRequiredAttributes(addressAttributeSets));
            this.registerPreProcessor(new CheckExclusiveAttributes(addressAttributeSets));
        }
    }
}

