/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.context.EntityCollector;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.ResponseMapper;
import org.neo4j.ogm.entity.io.EntityAccess;
import org.neo4j.ogm.entity.io.EntityAccessManager;
import org.neo4j.ogm.entity.io.EntityFactory;
import org.neo4j.ogm.entity.io.FieldWriter;
import org.neo4j.ogm.entity.io.PropertyReader;
import org.neo4j.ogm.entity.io.RelationalReader;
import org.neo4j.ogm.entity.io.RelationalWriter;
import org.neo4j.ogm.exception.BaseClassNotFoundException;
import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.response.model.PropertyModel;
import org.neo4j.ogm.utils.ClassUtils;
import org.neo4j.ogm.utils.EntityUtils;
import org.neo4j.ogm.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphEntityMapper
implements ResponseMapper<GraphModel> {
    private final Logger logger = LoggerFactory.getLogger(GraphEntityMapper.class);
    private final MappingContext mappingContext;
    private final EntityFactory entityFactory;
    private final MetaData metadata;

    public GraphEntityMapper(MetaData metaData, MappingContext mappingContext) {
        this.metadata = metaData;
        this.entityFactory = new EntityFactory(this.metadata);
        this.mappingContext = mappingContext;
    }

    public <T> Iterable<T> map(Class<T> type, Response<GraphModel> model) {
        GraphModel graphModel;
        ArrayList<T> objects = new ArrayList<T>();
        HashSet<Long> objectIds = new HashSet<Long>();
        LinkedHashSet<Long> nodeIds = new LinkedHashSet<Long>();
        LinkedHashSet<Long> edgeIds = new LinkedHashSet<Long>();
        while ((graphModel = (GraphModel)model.next()) != null) {
            List<T> mappedEntities = this.map(type, graphModel, nodeIds, edgeIds);
            for (T entity : mappedEntities) {
                Long identity = EntityUtils.identity(entity, this.metadata);
                if (objectIds.contains(identity)) continue;
                objects.add(entity);
                objectIds.add(identity);
            }
        }
        model.close();
        return objects;
    }

    public Map<Long, Object> mapRelationships(GraphModel model) {
        HashMap<Long, Object> results = new HashMap<Long, Object>();
        LinkedHashSet<Long> edgeIds = new LinkedHashSet<Long>();
        this.mapRelationships(model, edgeIds);
        for (Long id : edgeIds) {
            Object o = this.mappingContext.getRelationshipEntity(id);
            if (o == null) continue;
            results.put(id, o);
        }
        return results;
    }

    public <T> List<T> map(Class<T> type, GraphModel graphModel) {
        LinkedHashSet<Long> nodeIds = new LinkedHashSet<Long>();
        LinkedHashSet<Long> edgeIds = new LinkedHashSet<Long>();
        return this.map(type, graphModel, nodeIds, edgeIds);
    }

    public <T> List<T> map(Class<T> type, GraphModel graphModel, Set<Long> nodeIds, Set<Long> edgeIds) {
        Object o;
        this.mapEntities(type, graphModel, nodeIds, edgeIds);
        ArrayList<T> results = new ArrayList<T>();
        for (Long id : nodeIds) {
            o = this.mappingContext.getNodeEntity(id);
            if (o == null || !type.isAssignableFrom(o.getClass())) continue;
            results.add(type.cast(o));
        }
        if (results.isEmpty()) {
            for (Long id : edgeIds) {
                o = this.mappingContext.getRelationshipEntity(id);
                if (o == null || !type.isAssignableFrom(o.getClass())) continue;
                results.add(type.cast(o));
            }
        }
        return results;
    }

    private <T> void mapEntities(Class<T> type, GraphModel graphModel, Set<Long> nodeIds, Set<Long> edgeIds) {
        try {
            this.mapNodes(graphModel, nodeIds);
            this.mapRelationships(graphModel, edgeIds);
        }
        catch (Exception e) {
            throw new MappingException("Error mapping GraphModel to instance of " + type.getName(), e);
        }
    }

    private void mapNodes(GraphModel graphModel, Set<Long> nodeIds) {
        for (Node node : graphModel.getNodes()) {
            if (nodeIds.contains(node.getId())) continue;
            Object entity = this.mappingContext.getNodeEntity(node.getId());
            try {
                if (entity == null) {
                    entity = this.entityFactory.newObject(node);
                    this.setIdentity(entity, node.getId());
                    this.setProperties(node, entity);
                    this.setLabels(node, entity);
                    this.mappingContext.addNodeEntity(entity, node.getId());
                }
                nodeIds.add(node.getId());
            }
            catch (BaseClassNotFoundException e) {
                this.logger.debug(e.getMessage());
            }
        }
    }

    private void setIdentity(Object instance, Long id) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        FieldInfo fieldInfo = classInfo.identityField();
        FieldWriter.write(classInfo.getField(fieldInfo), instance, id);
    }

    private void setProperties(Node nodeModel, Object instance) {
        List propertyList = nodeModel.getPropertyList();
        ClassInfo classInfo = this.metadata.classInfo(instance);
        Collection<FieldInfo> compositeFields = classInfo.fieldsInfo().compositeFields();
        if (compositeFields.size() > 0) {
            Map<String, ?> propertyMap = PropertyUtils.toMap(propertyList);
            for (FieldInfo field : compositeFields) {
                Object value = field.getCompositeConverter().toEntityAttribute(propertyMap);
                EntityAccess writer = EntityAccessManager.getPropertyWriter(classInfo, field.getName());
                writer.write(instance, value);
            }
        }
        for (Property property : propertyList) {
            this.writeProperty(classInfo, instance, property);
        }
    }

    private void setProperties(Edge relationshipModel, Object instance) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        for (Property property : relationshipModel.getPropertyList()) {
            this.writeProperty(classInfo, instance, property);
        }
    }

    private void setLabels(Node nodeModel, Object instance) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        FieldInfo labelFieldInfo = classInfo.labelFieldOrNull();
        if (labelFieldInfo != null) {
            Collection<String> staticLabels = classInfo.staticLabels();
            HashSet<String> dynamicLabels = new HashSet<String>();
            for (String label : nodeModel.getLabels()) {
                if (staticLabels.contains(label)) continue;
                dynamicLabels.add(label);
            }
            this.writeProperty(classInfo, instance, (Property<?, ?>)PropertyModel.with((Object)labelFieldInfo.getName(), dynamicLabels));
        }
    }

    private void writeProperty(ClassInfo classInfo, Object instance, Property<?, ?> property) {
        EntityAccess writer = EntityAccessManager.getPropertyWriter(classInfo, property.getKey().toString());
        if (writer == null) {
            this.logger.debug("Unable to find property: {} on class: {} for writing", property.getKey(), (Object)classInfo.name());
        } else {
            PropertyReader reader;
            Object value = property.getValue();
            if ((writer.type().isArray() || Iterable.class.isAssignableFrom(writer.type())) && (reader = EntityAccessManager.getPropertyReader(classInfo, property.getKey().toString())) != null) {
                Object currentValue = reader.readProperty(instance);
                Class<?> paramType = writer.type();
                Class elementType = this.underlyingElementType(classInfo, property.getKey().toString());
                value = paramType.isArray() ? EntityAccess.merge(paramType, value, (Object[])currentValue, elementType) : EntityAccess.merge(paramType, value, (Collection)currentValue, elementType);
            }
            writer.write(instance, value);
        }
    }

    private boolean tryMappingAsSingleton(Object source, Object parameter, Edge edge, String relationshipDirection) {
        String edgeLabel = edge.getType();
        ClassInfo sourceInfo = this.metadata.classInfo(source);
        RelationalWriter writer = EntityAccessManager.getRelationalWriter(sourceInfo, edgeLabel, relationshipDirection, parameter);
        if (writer != null && writer.forScalar()) {
            writer.write(source, parameter);
            return true;
        }
        return false;
    }

    private void mapRelationships(GraphModel graphModel, Set<Long> edgeIds) {
        ArrayList<Edge> oneToMany = new ArrayList<Edge>();
        for (Edge edge : graphModel.getRelationships()) {
            if (edgeIds.contains(edge.getId())) continue;
            Object source = this.mappingContext.getNodeEntity(edge.getStartNode());
            Object target = this.mappingContext.getNodeEntity(edge.getEndNode());
            edgeIds.add(edge.getId());
            if (source != null && target != null) {
                ClassInfo relationshipEntityClassInfo = this.getRelationshipEntity(edge);
                if (relationshipEntityClassInfo != null) {
                    this.mapRelationshipEntity(oneToMany, edge, source, target, relationshipEntityClassInfo);
                    continue;
                }
                this.mapRelationship(oneToMany, edge, source, target);
                continue;
            }
            this.logger.debug("Relationship {} cannot be hydrated because one or more required node types are not mapped to entity classes", (Object)edge);
        }
        if (oneToMany.size() > 0) {
            this.mapOneToMany(oneToMany);
        }
    }

    private void mapRelationship(List<Edge> oneToMany, Edge edge, Object source, Object target) {
        boolean oneToOne = this.tryMappingAsSingleton(source, target, edge, "OUTGOING");
        if (!(oneToOne &= this.tryMappingAsSingleton(target, source, edge, "INCOMING"))) {
            oneToMany.add(edge);
        } else {
            RelationalWriter writer = EntityAccessManager.getRelationalWriter(this.metadata.classInfo(source), edge.getType(), "OUTGOING", target);
            this.mappingContext.addRelationship(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), source.getClass(), ClassUtils.getType(writer.typeParameterDescriptor())));
        }
    }

    private void mapRelationshipEntity(List<Edge> oneToMany, Edge edge, Object source, Object target, ClassInfo relationshipEntityClassInfo) {
        ClassInfo sourceInfo;
        RelationalWriter writer;
        this.logger.debug("Found relationship type: {} to map to RelationshipEntity: {}", (Object)edge.getType(), (Object)relationshipEntityClassInfo.name());
        Object relationshipEntity = this.mappingContext.getRelationshipEntity(edge.getId());
        if (relationshipEntity == null) {
            relationshipEntity = this.createRelationshipEntity(edge, source, target);
        }
        if ((writer = EntityAccessManager.getRelationalWriter(sourceInfo = this.metadata.classInfo(source), edge.getType(), "OUTGOING", relationshipEntity)) == null) {
            this.logger.debug("No writer for {}", target);
        } else if (writer.forScalar()) {
            writer.write(source, relationshipEntity);
            this.mappingContext.addRelationship(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), source.getClass(), ClassUtils.getType(writer.typeParameterDescriptor())));
        } else {
            oneToMany.add(edge);
        }
        ClassInfo targetInfo = this.metadata.classInfo(target);
        writer = EntityAccessManager.getRelationalWriter(targetInfo, edge.getType(), "INCOMING", relationshipEntity);
        if (writer == null) {
            this.logger.debug("No writer for {}", target);
        } else if (writer.forScalar()) {
            writer.write(target, relationshipEntity);
        } else {
            oneToMany.add(edge);
        }
    }

    private Object createRelationshipEntity(Edge edge, Object startEntity, Object endEntity) {
        Object relationshipEntity = this.entityFactory.newObject(this.getRelationshipEntity(edge));
        this.setIdentity(relationshipEntity, edge.getId());
        this.setProperties(edge, relationshipEntity);
        this.mappingContext.addRelationshipEntity(relationshipEntity, edge.getId());
        ClassInfo relEntityInfo = this.metadata.classInfo(relationshipEntity);
        RelationalWriter startNodeWriter = EntityAccessManager.getStartOrEndNodeWriter(relEntityInfo, StartNode.class);
        if (startNodeWriter == null) {
            throw new RuntimeException("Cannot find a writer for the StartNode of relational entity " + relEntityInfo.name());
        }
        startNodeWriter.write(relationshipEntity, startEntity);
        RelationalWriter endNodeWriter = EntityAccessManager.getStartOrEndNodeWriter(relEntityInfo, EndNode.class);
        if (endNodeWriter == null) {
            throw new RuntimeException("Cannot find a writer for the EndNode of relational entity " + relEntityInfo.name());
        }
        endNodeWriter.write(relationshipEntity, endEntity);
        return relationshipEntity;
    }

    private void mapOneToMany(Collection<Edge> oneToManyRelationships) {
        EntityCollector entityCollector = new EntityCollector();
        ArrayList<MappedRelationship> relationshipsToRegister = new ArrayList<MappedRelationship>();
        HashSet<Edge> registeredEdges = new HashSet<Edge>();
        for (Edge edge : oneToManyRelationships) {
            RelationalWriter incomingWriter;
            RelationalWriter outgoingWriter;
            Object instance = this.mappingContext.getNodeEntity(edge.getStartNode());
            Object parameter = this.mappingContext.getNodeEntity(edge.getEndNode());
            Object relationshipEntity = this.mappingContext.getRelationshipEntity(edge.getId());
            if (relationshipEntity != null) {
                outgoingWriter = this.findIterableWriter(instance, relationshipEntity, edge.getType(), "OUTGOING");
                if (outgoingWriter != null) {
                    entityCollector.recordTypeRelationship(edge.getStartNode(), relationshipEntity, edge.getType(), "OUTGOING");
                    relationshipsToRegister.add(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), instance.getClass(), ClassUtils.getType(outgoingWriter.typeParameterDescriptor())));
                }
                if ((incomingWriter = this.findIterableWriter(parameter, relationshipEntity, edge.getType(), "INCOMING")) != null) {
                    entityCollector.recordTypeRelationship(edge.getEndNode(), relationshipEntity, edge.getType(), "INCOMING");
                    relationshipsToRegister.add(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), instance.getClass(), ClassUtils.getType(incomingWriter.typeParameterDescriptor())));
                }
                if (incomingWriter == null && outgoingWriter == null) continue;
                registeredEdges.add(edge);
                continue;
            }
            outgoingWriter = this.findIterableWriter(instance, parameter, edge.getType(), "OUTGOING");
            if (outgoingWriter != null) {
                entityCollector.recordTypeRelationship(edge.getStartNode(), parameter, edge.getType(), "OUTGOING");
                relationshipsToRegister.add(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), instance.getClass(), ClassUtils.getType(outgoingWriter.typeParameterDescriptor())));
            }
            if ((incomingWriter = this.findIterableWriter(parameter, instance, edge.getType(), "INCOMING")) != null) {
                entityCollector.recordTypeRelationship(edge.getEndNode(), instance, edge.getType(), "INCOMING");
                relationshipsToRegister.add(new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), instance.getClass(), ClassUtils.getType(incomingWriter.typeParameterDescriptor())));
            }
            if (incomingWriter == null && outgoingWriter == null) continue;
            registeredEdges.add(edge);
        }
        for (Long instanceId : entityCollector.getOwningTypes()) {
            for (String relationshipType : entityCollector.getOwningRelationshipTypes(instanceId)) {
                for (String relationshipDirection : entityCollector.getRelationshipDirectionsForOwningTypeAndRelationshipType(instanceId, relationshipType)) {
                    for (Class entityClass : entityCollector.getEntityClassesForOwningTypeAndRelationshipTypeAndRelationshipDirection(instanceId, relationshipType, relationshipDirection)) {
                        Set<Object> entities = entityCollector.getCollectiblesForOwnerAndRelationship(instanceId, relationshipType, relationshipDirection, entityClass);
                        this.mapOneToMany(this.mappingContext.getNodeEntity(instanceId), entityClass, entities, relationshipType, relationshipDirection);
                    }
                }
            }
        }
        for (MappedRelationship mappedRelationship : relationshipsToRegister) {
            this.mappingContext.addRelationship(mappedRelationship);
        }
        for (Edge edge : oneToManyRelationships) {
            MappedRelationship mappedRelationship;
            if (registeredEdges.contains(edge)) continue;
            Object source = this.mappingContext.getNodeEntity(edge.getStartNode());
            Object target = this.mappingContext.getNodeEntity(edge.getEndNode());
            RelationalWriter writer = EntityAccessManager.getRelationalWriter(this.metadata.classInfo(source), edge.getType(), "OUTGOING", target);
            if (writer == null) {
                writer = EntityAccessManager.getRelationalWriter(this.metadata.classInfo(target), edge.getType(), "INCOMING", source);
            }
            if (writer == null || this.mappingContext.containsRelationship(mappedRelationship = new MappedRelationship(edge.getStartNode(), edge.getType(), edge.getEndNode(), edge.getId(), source.getClass(), ClassUtils.getType(writer.typeParameterDescriptor())))) continue;
            this.mappingContext.addRelationship(mappedRelationship);
        }
    }

    private RelationalWriter findIterableWriter(Object instance, Object parameter, String relationshipType, String relationshipDirection) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        return EntityAccessManager.getIterableWriter(classInfo, parameter.getClass(), relationshipType, relationshipDirection);
    }

    private void mapOneToMany(Object instance, Class<?> valueType, Object values, String relationshipType, String relationshipDirection) {
        ClassInfo classInfo = this.metadata.classInfo(instance);
        RelationalWriter writer = EntityAccessManager.getIterableWriter(classInfo, valueType, relationshipType, relationshipDirection);
        if (writer != null) {
            RelationalReader reader;
            if ((writer.type().isArray() || Iterable.class.isAssignableFrom(writer.type())) && (reader = EntityAccessManager.getIterableReader(classInfo, valueType, relationshipType, relationshipDirection)) != null) {
                Object currentValues = reader.read(instance);
                values = writer.type().isArray() ? EntityAccess.merge(writer.type(), values, (Object[])currentValues, valueType) : EntityAccess.merge(writer.type(), values, (Collection)currentValues, valueType);
            }
            writer.write(instance, values);
            return;
        }
        this.logger.debug("Unable to map iterable of type: {} onto property of {}", valueType, (Object)classInfo.name());
    }

    private ClassInfo getRelationshipEntity(Edge edge) {
        Object source = this.mappingContext.getNodeEntity(edge.getStartNode());
        Object target = this.mappingContext.getNodeEntity(edge.getEndNode());
        Set<ClassInfo> classInfos = this.metadata.classInfoByLabelOrType(edge.getType());
        for (ClassInfo classInfo : classInfos) {
            if (!this.nodeTypeMatches(classInfo, source, "org.neo4j.ogm.annotation.StartNode") || !this.nodeTypeMatches(classInfo, target, "org.neo4j.ogm.annotation.EndNode")) continue;
            Class relationshipEntityClass = classInfo.getUnderlyingClass();
            if (this.declaresRelationshipTo(relationshipEntityClass, source.getClass(), edge.getType(), "OUTGOING")) {
                return classInfo;
            }
            if (!this.declaresRelationshipTo(relationshipEntityClass, target.getClass(), edge.getType(), "INCOMING")) continue;
            return classInfo;
        }
        if (classInfos.size() == 1) {
            ClassInfo classInfo = classInfos.iterator().next();
            if (this.nodeTypeMatches(classInfo, source, "org.neo4j.ogm.annotation.StartNode") && this.nodeTypeMatches(classInfo, target, "org.neo4j.ogm.annotation.EndNode")) {
                return classInfo;
            }
        } else if (classInfos.size() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to find a matching @RelationshipEntity for {}", (Object)edge.toString());
            }
        } else {
            this.logger.error("Found more than one matching @RelationshipEntity for {} but cannot tell which one to use", (Object)edge.toString());
        }
        return null;
    }

    private boolean declaresRelationshipTo(Class to, Class by, String relationshipName, String relationshipDirection) {
        return EntityAccessManager.getRelationalWriter(this.metadata.classInfo(by.getName()), relationshipName, relationshipDirection, to) != null;
    }

    private boolean nodeTypeMatches(ClassInfo classInfo, Object node, String annotation) {
        FieldInfo field;
        List<FieldInfo> fields = classInfo.findFields(annotation);
        return fields.size() == 1 && (field = fields.get(0)).isTypeOf(node.getClass());
    }

    private Class underlyingElementType(ClassInfo classInfo, String propertyName) {
        FieldInfo fieldInfo = this.fieldInfoForPropertyName(propertyName, classInfo);
        Class<?> clazz = null;
        if (fieldInfo != null) {
            clazz = ClassUtils.getType(fieldInfo.getTypeDescriptor());
        }
        return clazz;
    }

    private FieldInfo fieldInfoForPropertyName(String propertyName, ClassInfo classInfo) {
        FieldInfo labelField = classInfo.labelFieldOrNull();
        if (labelField != null && labelField.getName().toLowerCase().equals(propertyName.toLowerCase())) {
            return labelField;
        }
        return classInfo.propertyField(propertyName);
    }
}

