/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.util.Collections;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.query.CypherQuery;
import org.neo4j.ogm.cypher.query.DefaultRowModelRequest;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.FilteredQueryBuilder;
import org.neo4j.ogm.session.request.strategy.AggregateStatements;

public class CountStatements
implements AggregateStatements {
    @Override
    public CypherQuery countNodes() {
        return new DefaultRowModelRequest("MATCH (n) RETURN COUNT(n)", Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery countNodes(String label) {
        return this.countNodes(Collections.singletonList(label));
    }

    @Override
    public CypherQuery countNodes(Iterable<String> labels) {
        StringBuilder cypherLabels = new StringBuilder();
        for (String label : labels) {
            cypherLabels.append(":`").append(label).append('`');
        }
        return new DefaultRowModelRequest(String.format("MATCH (n%s) RETURN COUNT(n)", cypherLabels.toString()), Collections.emptyMap());
    }

    @Override
    public CypherQuery countNodes(String label, Iterable<Filter> filters) {
        FilteredQuery query = FilteredQueryBuilder.buildNodeQuery(label, filters);
        query.setReturnClause(" RETURN COUNT(n)");
        return new DefaultRowModelRequest(query.statement(), query.parameters());
    }

    @Override
    public CypherQuery countEdges() {
        return new DefaultRowModelRequest("MATCH (n)-[r0]->() RETURN COUNT(r0)", Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery countEdges(String type) {
        return new DefaultRowModelRequest(String.format("MATCH (n)-[r0:`%s`]->() RETURN COUNT(r0)", type), Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery countEdges(String type, Iterable<Filter> filters) {
        FilteredQuery query = FilteredQueryBuilder.buildRelationshipQuery(type, filters);
        query.setReturnClause(" RETURN COUNT(r0)");
        return new DefaultRowModelRequest(query.statement(), query.parameters());
    }

    @Override
    public CypherQuery countEdges(String startLabel, String type, String endLabel) {
        return new DefaultRowModelRequest(String.format("MATCH (:`%s`)-[r0:`%s`]->(:`%s`) RETURN COUNT(r0)", startLabel, type, endLabel), Utils.map(new Object[0]));
    }
}

