/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.io.Serializable;
import java.util.Collection;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.DefaultGraphModelRequest;
import org.neo4j.ogm.cypher.query.DefaultGraphRowListModelRequest;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.FilteredQueryBuilder;
import org.neo4j.ogm.session.request.strategy.QueryStatements;

public class NodeQueryStatements<ID extends Serializable>
implements QueryStatements<ID> {
    private String primaryIndex;

    public NodeQueryStatements() {
    }

    public NodeQueryStatements(String primaryIndex) {
        this.primaryIndex = primaryIndex;
    }

    @Override
    public PagingAndSortingQuery findOne(ID id, int depth) {
        return this.findOneByType("", id, depth);
    }

    @Override
    public PagingAndSortingQuery findOneByType(String label, ID id, int depth) {
        String match = "n";
        if (label != null && !label.equals("")) {
            match = String.format("%s:`%s`", match, label);
        }
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findOne(id, this.primaryIndex);
        }
        if (max > 0) {
            String qry = this.primaryIndex != null ? String.format("MATCH (%s) WHERE n." + this.primaryIndex + " = { id } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", match, min, max) : String.format("MATCH (%s) WHERE ID(n) = { id } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", match, min, max);
            return new DefaultGraphModelRequest(qry, Utils.map("id", id));
        }
        return DepthZeroReadStrategy.findOne(id, this.primaryIndex);
    }

    @Override
    public PagingAndSortingQuery findAll(Collection<ID> ids, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findAll(ids);
        }
        if (max > 0) {
            String qry = String.format("MATCH (n) WHERE ID(n) IN { ids } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", min, max);
            return new DefaultGraphModelRequest(qry, Utils.map("ids", ids));
        }
        return DepthZeroReadStrategy.findAll(ids);
    }

    @Override
    public PagingAndSortingQuery findAllByType(String label, Collection<ID> ids, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findAllByLabel(label, ids, this.primaryIndex);
        }
        if (max > 0) {
            String qry = this.primaryIndex != null ? String.format("MATCH (n:`%s`) WHERE n." + this.primaryIndex + " IN { ids } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", label, min, max) : String.format("MATCH (n:`%s`) WHERE ID(n) IN { ids } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", label, min, max);
            return new DefaultGraphModelRequest(qry, Utils.map("ids", ids));
        }
        return DepthZeroReadStrategy.findAllByLabel(label, ids, this.primaryIndex);
    }

    @Override
    public PagingAndSortingQuery findAll() {
        return new DefaultGraphModelRequest("MATCH p=()-->() RETURN p", Utils.map(new Object[0]));
    }

    @Override
    public PagingAndSortingQuery findByType(String label, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findByLabel(label);
        }
        if (max > 0) {
            String qry = String.format("MATCH (n:`%s`) WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", label, min, max);
            return new DefaultGraphModelRequest(qry, Utils.map(new Object[0]));
        }
        return DepthZeroReadStrategy.findByLabel(label);
    }

    @Override
    public PagingAndSortingQuery findByType(String label, Filters parameters, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findByProperties(label, parameters);
        }
        if (max > 0) {
            FilteredQuery query = FilteredQueryBuilder.buildNodeQuery(label, parameters);
            query.setReturnClause(String.format("WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p, ID(n)", min, max));
            return new DefaultGraphRowListModelRequest(query.statement(), query.parameters());
        }
        return DepthZeroReadStrategy.findByProperties(label, parameters);
    }

    private int min(int depth) {
        return Math.min(0, depth);
    }

    private int max(int depth) {
        return Math.max(0, depth);
    }

    private static class InfiniteDepthReadStrategy {
        private InfiniteDepthReadStrategy() {
        }

        public static <ID extends Serializable> DefaultGraphModelRequest findOne(ID id, String primaryIndex) {
            if (primaryIndex != null) {
                return new DefaultGraphModelRequest("MATCH (n) WHERE n." + primaryIndex + " = { id } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", Utils.map("id", id));
            }
            return new DefaultGraphModelRequest("MATCH (n) WHERE ID(n) = { id } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", Utils.map("id", id));
        }

        public static <ID extends Serializable> DefaultGraphModelRequest findAll(Collection<ID> ids) {
            return new DefaultGraphModelRequest("MATCH (n) WHERE ID(n) IN { ids } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", Utils.map("ids", ids));
        }

        public static <ID extends Serializable> DefaultGraphModelRequest findAllByLabel(String label, Collection<ID> ids, String primaryIndex) {
            String queryString = primaryIndex != null ? String.format("MATCH (n:`%s`) WHERE n." + primaryIndex + " IN { ids } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", label) : String.format("MATCH (n:`%s`) WHERE ID(n) IN { ids } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", label);
            return new DefaultGraphModelRequest(queryString, Utils.map("ids", ids));
        }

        public static DefaultGraphModelRequest findByLabel(String label) {
            return new DefaultGraphModelRequest(String.format("MATCH (n:`%s`) WITH n MATCH p=(n)-[*0..]-(m) RETURN p", label), Utils.map(new Object[0]));
        }

        public static DefaultGraphRowListModelRequest findByProperties(String label, Filters parameters) {
            FilteredQuery query = FilteredQueryBuilder.buildNodeQuery(label, parameters);
            query.setReturnClause(" WITH n MATCH p=(n)-[*0..]-(m) RETURN p, ID(n)");
            return new DefaultGraphRowListModelRequest(query.statement(), query.parameters());
        }
    }

    private static class DepthZeroReadStrategy {
        private DepthZeroReadStrategy() {
        }

        public static <ID extends Serializable> DefaultGraphModelRequest findOne(ID id, String primaryIndex) {
            if (primaryIndex != null) {
                return new DefaultGraphModelRequest("MATCH (n) WHERE n." + primaryIndex + " = { id } RETURN n", Utils.map("id", id));
            }
            return new DefaultGraphModelRequest("MATCH (n) WHERE ID(n) = { id } RETURN n", Utils.map("id", id));
        }

        public static <ID extends Serializable> DefaultGraphModelRequest findAll(Collection<ID> ids) {
            return new DefaultGraphModelRequest("MATCH (n) WHERE ID(n) IN { ids } RETURN n", Utils.map("ids", ids));
        }

        public static <ID extends Serializable> DefaultGraphModelRequest findAllByLabel(String label, Collection<ID> ids, String primaryIndex) {
            String queryString = primaryIndex != null ? String.format("MATCH (n:`%s`) WHERE n." + primaryIndex + " IN { ids } RETURN n", label) : String.format("MATCH (n:`%s`) WHERE ID(n) IN { ids } RETURN n", label);
            return new DefaultGraphModelRequest(queryString, Utils.map("ids", ids));
        }

        public static DefaultGraphModelRequest findByLabel(String label) {
            return new DefaultGraphModelRequest(String.format("MATCH (n:`%s`) RETURN n", label), Utils.map(new Object[0]));
        }

        public static DefaultGraphModelRequest findByProperties(String label, Filters parameters) {
            FilteredQuery query = FilteredQueryBuilder.buildNodeQuery(label, parameters);
            query.setReturnClause("RETURN n");
            return new DefaultGraphModelRequest(query.statement(), query.parameters());
        }
    }
}

