/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.query;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.cypher.query.CypherQuery;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.PagingAndSorting;
import org.neo4j.ogm.cypher.query.SortOrder;

public class PagingAndSortingQuery
extends CypherQuery
implements PagingAndSorting {
    private Pagination paging;
    private SortOrder sortOrder = new SortOrder();

    protected PagingAndSortingQuery(String cypher, Map<String, ?> parameters) {
        super(cypher, parameters);
    }

    @Override
    public String getStatement() {
        String pagination;
        String stmt = this.statement.trim();
        String sorting = this.sortOrder().toString();
        String string = pagination = this.paging == null ? "" : this.page().toString();
        if (sorting.length() > 0 || pagination.length() > 0) {
            if (this.withIndex > -1) {
                String withClause;
                int nextClauseIndex = stmt.indexOf(" MATCH", this.withIndex);
                String newWithClause = withClause = stmt.substring(this.withIndex, nextClauseIndex);
                if (stmt.contains(")-[r0")) {
                    sorting = sorting.replace("$", "r0");
                    if (!withClause.contains(",r0") && !withClause.contains("r0,")) {
                        newWithClause = StringUtils.removeEnd((String)newWithClause, (String)"n") + "distinct n";
                    }
                } else {
                    sorting = sorting.replace("$", "n");
                }
                if ((stmt = stmt.replace(withClause, newWithClause + sorting + pagination)).contains("MATCH p=(") && !stmt.contains("RETURN p, ID(n)")) {
                    stmt = stmt.replace("RETURN p", "RETURN p, ID(n)");
                }
            } else {
                if (stmt.startsWith("MATCH p=(")) {
                    String withClause = "WITH p";
                    if (stmt.contains(")-[r")) {
                        withClause = withClause + ",r0";
                        sorting = sorting.replace("$", "r0");
                    } else {
                        sorting = sorting.replace("$", "n");
                    }
                    stmt = stmt.replace("RETURN ", withClause + sorting + pagination + " RETURN ");
                } else {
                    sorting = sorting.replace("$", "n");
                    stmt = stmt.replace("RETURN ", "WITH n" + sorting + pagination + " RETURN ");
                }
                if (stmt.contains("MATCH p=(") && stmt.contains("WITH n") && !stmt.contains("RETURN p, ID(n)")) {
                    stmt = stmt.replace("RETURN p", "RETURN p, ID(n)");
                }
            }
        }
        return stmt;
    }

    @Override
    public PagingAndSortingQuery setPagination(Pagination paging) {
        this.paging = paging;
        return this;
    }

    @Override
    public PagingAndSortingQuery setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public Pagination page() {
        return this.paging;
    }

    public SortOrder sortOrder() {
        return this.sortOrder;
    }
}

