/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.exception.MissingOperatorException;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.NodeQueryBuilder;

public class FilteredQueryBuilder {
    public static FilteredQuery buildNodeQuery(String nodeLabel, Iterable<Filter> filterList) {
        return new NodeQueryBuilder(nodeLabel, filterList).build();
    }

    public static FilteredQuery buildRelationshipQuery(String relationshipType, Iterable<Filter> filterList) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        StringBuilder sb = FilteredQueryBuilder.constructRelationshipQuery(relationshipType, filterList, properties);
        return new FilteredQuery(sb, properties);
    }

    private static StringBuilder constructRelationshipQuery(String type, Iterable<Filter> filters, Map<String, Object> properties) {
        ArrayList<Filter> startNodeFilters = new ArrayList<Filter>();
        ArrayList<Filter> endNodeFilters = new ArrayList<Filter>();
        ArrayList<Filter> relationshipFilters = new ArrayList<Filter>();
        String startNodeLabel = null;
        String endNodeLabel = null;
        boolean noneOperatorEncounteredInStartFilters = false;
        boolean noneOperatorEncounteredInEndFilters = false;
        for (Filter filter : filters) {
            if (filter.isNested()) {
                if (filter.getBooleanOperator().equals((Object)BooleanOperator.OR)) {
                    throw new UnsupportedOperationException("OR is not supported for nested properties on a relationship entity");
                }
                if (filter.getRelationshipDirection().equals("OUTGOING")) {
                    if (filter.getBooleanOperator().equals((Object)BooleanOperator.NONE)) {
                        if (noneOperatorEncounteredInStartFilters) {
                            throw new MissingOperatorException("BooleanOperator missing for filter with property name " + filter.getPropertyName());
                        }
                        noneOperatorEncounteredInStartFilters = true;
                    }
                    if (startNodeLabel == null) {
                        startNodeLabel = filter.getNestedEntityTypeLabel();
                        filter.setBooleanOperator(BooleanOperator.NONE);
                    }
                    startNodeFilters.add(filter);
                    continue;
                }
                if (filter.getBooleanOperator().equals((Object)BooleanOperator.NONE)) {
                    if (noneOperatorEncounteredInEndFilters) {
                        throw new MissingOperatorException("BooleanOperator missing for filter with property name " + filter.getPropertyName());
                    }
                    noneOperatorEncounteredInEndFilters = true;
                }
                if (endNodeLabel == null) {
                    endNodeLabel = filter.getNestedEntityTypeLabel();
                    filter.setBooleanOperator(BooleanOperator.NONE);
                }
                endNodeFilters.add(filter);
                continue;
            }
            if (relationshipFilters.size() == 0) {
                filter.setBooleanOperator(BooleanOperator.NONE);
            } else if (filter.getBooleanOperator().equals((Object)BooleanOperator.NONE)) {
                throw new MissingOperatorException("BooleanOperator missing for filter with property name " + filter.getPropertyName());
            }
            relationshipFilters.add(filter);
        }
        StringBuilder query = new StringBuilder();
        FilteredQueryBuilder.createNodeMatchSubquery(properties, startNodeFilters, startNodeLabel, query, "n");
        FilteredQueryBuilder.createNodeMatchSubquery(properties, endNodeFilters, endNodeLabel, query, "m");
        FilteredQueryBuilder.createRelationSubquery(type, properties, relationshipFilters, query);
        return query;
    }

    private static void createRelationSubquery(String type, Map<String, Object> properties, List<Filter> relationshipFilters, StringBuilder query) {
        query.append(String.format("MATCH (n)-[r0:`%s`]->(m) ", type));
        if (relationshipFilters.size() > 0) {
            query.append("WHERE ");
            FilteredQueryBuilder.appendFilters(relationshipFilters, "r0", query, properties);
        }
    }

    private static void createNodeMatchSubquery(Map<String, Object> properties, List<Filter> nodeFilters, String nodeLabel, StringBuilder query, String nodeIdentifier) {
        if (nodeLabel != null) {
            query.append(String.format("MATCH (%s:`%s`) WHERE ", nodeIdentifier, nodeLabel));
            FilteredQueryBuilder.appendFilters(nodeFilters, nodeIdentifier, query, properties);
        }
    }

    private static void appendFilters(List<Filter> filters, String nodeIdentifier, StringBuilder query, Map<String, Object> properties) {
        for (Filter filter : filters) {
            query.append(filter.toCypher(nodeIdentifier, false));
            properties.putAll(filter.getFunction().parameters());
        }
    }
}

