/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.utils;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.CollectionUtils;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.entity.io.EntityAccessManager;
import org.neo4j.ogm.entity.io.FieldReader;
import org.neo4j.ogm.entity.io.FieldWriter;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;

public class EntityUtils {
    private static AtomicLong idSequence = new AtomicLong(0L);

    public static Long identity(Object entity, MetaData metaData) {
        ClassInfo classInfo = metaData.classInfo(entity);
        Object id = EntityAccessManager.getIdentityPropertyReader(classInfo).readProperty(entity);
        if (id == null) {
            Long generated = idSequence.decrementAndGet();
            Field identityField = classInfo.getField(classInfo.identityField());
            FieldWriter.write(identityField, entity, generated);
            return generated;
        }
        return (Long)id;
    }

    public static Collection<String> labels(Object entity, MetaData metaData) {
        ClassInfo classInfo = metaData.classInfo(entity);
        Collection<String> staticLabels = classInfo.staticLabels();
        FieldInfo labelFieldInfo = classInfo.labelFieldOrNull();
        if (labelFieldInfo != null) {
            FieldReader reader = new FieldReader(classInfo, labelFieldInfo);
            Collection labels = (Collection)reader.readProperty(entity);
            return CollectionUtils.union(staticLabels, (Iterable)labels);
        }
        return staticLabels;
    }
}

