/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.exception.core.MissingOperatorException;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.MatchClause;
import org.neo4j.ogm.session.request.NestedPathMatchClause;
import org.neo4j.ogm.session.request.NestedPropertyPathMatchClause;
import org.neo4j.ogm.session.request.PathMatchClause;
import org.neo4j.ogm.session.request.PrincipalNodeMatchClause;
import org.neo4j.ogm.session.request.RelatedNodePropertyMatchClause;
import org.neo4j.ogm.session.request.RelationshipPropertyMatchClause;

public class NodeQueryBuilder {
    private PrincipalNodeMatchClause principalClause;
    private Iterable<Filter> filters;
    private List<MatchClause> nestedClauses;
    private List<MatchClause> pathClauses;
    private Map<String, Object> parameters;
    private int matchClauseId;
    private boolean built = false;
    private boolean hasRelationshipMatch = false;

    NodeQueryBuilder(String principalLabel, Iterable<Filter> filters) {
        this.principalClause = new PrincipalNodeMatchClause(principalLabel);
        this.filters = filters;
        this.nestedClauses = new ArrayList<MatchClause>();
        this.pathClauses = new ArrayList<MatchClause>();
        this.parameters = new HashMap<String, Object>();
        this.matchClauseId = 0;
        this.built = false;
    }

    public FilteredQuery build() {
        if (!this.built) {
            int i = 0;
            for (Filter filter : this.filters) {
                if (i != 0 && filter.getBooleanOperator().equals((Object)BooleanOperator.NONE)) {
                    throw new MissingOperatorException("BooleanOperator missing for filter with property name " + filter.getPropertyName() + ". Only the first filter may not specify the BooleanOperator.");
                }
                if (filter.isNested()) {
                    this.appendNestedFilter(filter);
                    this.hasRelationshipMatch = true;
                } else if (filter.isDeepNested()) {
                    this.appendDeepNestedFilter(filter);
                    this.hasRelationshipMatch = true;
                } else {
                    this.principalClause().append(filter);
                }
                this.parameters.putAll(filter.parameters());
                ++i;
            }
            this.built = true;
        }
        return new FilteredQuery(this.toCypher(), this.parameters);
    }

    private void appendNestedFilter(Filter filter) {
        if (filter.getBooleanOperator().equals((Object)BooleanOperator.OR)) {
            throw new UnsupportedOperationException("OR is not supported for nested properties on an entity");
        }
        if (filter.isNestedRelationshipEntity()) {
            RelationshipPropertyMatchClause clause = this.relationshipPropertyClauseFor(filter.getRelationshipType());
            if (clause == null) {
                clause = new RelationshipPropertyMatchClause(this.matchClauseId, filter.getRelationshipType());
                this.nestedClauses.add(clause);
            }
            clause.append(filter);
        } else {
            RelatedNodePropertyMatchClause clause = this.relatedNodeClauseFor(filter.getNestedEntityTypeLabel());
            if (clause == null) {
                clause = new RelatedNodePropertyMatchClause(filter.getNestedEntityTypeLabel(), this.matchClauseId);
                this.nestedClauses.add(clause);
                this.pathClauses.add(new PathMatchClause(this.matchClauseId).append(filter));
            }
            clause.append(filter);
        }
        ++this.matchClauseId;
    }

    private void appendDeepNestedFilter(Filter filter) {
        if (filter.getBooleanOperator().equals((Object)BooleanOperator.OR)) {
            throw new UnsupportedOperationException("OR is not supported for nested properties on an entity");
        }
        Filter.NestedPathSegment lastPathSegment = filter.getNestedPath().get(filter.getNestedPath().size() - 1);
        NestedPropertyPathMatchClause clause = new NestedPropertyPathMatchClause(this.matchClauseId, lastPathSegment.getNestedEntityTypeLabel(), lastPathSegment.isNestedRelationshipEntity());
        this.pathClauses.add(new NestedPathMatchClause(this.matchClauseId).append(filter));
        this.nestedClauses.add(clause);
        clause.append(filter);
        ++this.matchClauseId;
    }

    private PrincipalNodeMatchClause principalClause() {
        return this.principalClause;
    }

    private RelatedNodePropertyMatchClause relatedNodeClauseFor(String label) {
        for (MatchClause clause : this.nestedClauses) {
            RelatedNodePropertyMatchClause nestedPropClause;
            if (!(clause instanceof RelatedNodePropertyMatchClause) || !(nestedPropClause = (RelatedNodePropertyMatchClause)clause).getLabel().equals(label)) continue;
            return nestedPropClause;
        }
        return null;
    }

    private RelationshipPropertyMatchClause relationshipPropertyClauseFor(String relationshipType) {
        for (MatchClause clause : this.nestedClauses) {
            RelationshipPropertyMatchClause relPropClause;
            if (!(clause instanceof RelationshipPropertyMatchClause) || !(relPropClause = (RelationshipPropertyMatchClause)clause).getRelationshipType().equals(relationshipType)) continue;
            return relPropClause;
        }
        return null;
    }

    private StringBuilder toCypher() {
        StringBuilder stringBuilder = new StringBuilder(this.principalClause.toCypher());
        for (MatchClause matchClause : this.nestedClauses) {
            stringBuilder.append(matchClause.toCypher());
        }
        for (MatchClause matchClause : this.pathClauses) {
            stringBuilder.append(matchClause.toCypher());
        }
        if (this.hasRelationshipMatch) {
            stringBuilder.append("WITH DISTINCT n");
        } else {
            stringBuilder.append("WITH n");
        }
        return stringBuilder;
    }
}

