/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Method;
import java.util.Objects;
import org.neo4j.ogm.metadata.ObjectAnnotations;

public class MethodInfo {
    private final String name;
    private final ObjectAnnotations annotations;
    private final Method method;

    static MethodInfo of(Method method) {
        ObjectAnnotations objectAnnotations = ObjectAnnotations.of(method.getDeclaredAnnotations());
        return new MethodInfo(method, objectAnnotations);
    }

    private MethodInfo(Method method, ObjectAnnotations annotations) {
        this.method = method;
        this.name = method.getName();
        this.annotations = annotations;
    }

    public String getName() {
        return this.name;
    }

    boolean hasAnnotation(Class<?> annotationClass) {
        return this.annotations.has(annotationClass);
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodInfo)) {
            return false;
        }
        MethodInfo that = (MethodInfo)o;
        return Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.method);
    }
}

