/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.transaction;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.ogm.exception.core.TransactionManagerException;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;

public class DefaultTransactionManager
implements TransactionManager {
    private final Session session;
    private final BiFunction<Transaction.Type, Iterable<String>, Transaction> transactionFactory;
    private final ThreadLocal<Transaction> currentThreadLocalTransaction = new ThreadLocal();

    public DefaultTransactionManager(Session session, Function<TransactionManager, BiFunction<Transaction.Type, Iterable<String>, Transaction>> transactionFactorySupplier) {
        this.session = session;
        this.transactionFactory = transactionFactorySupplier.apply(this);
    }

    public Transaction openTransaction() {
        Transaction tx = this.currentThreadLocalTransaction.get();
        if (tx == null) {
            return this.openTransaction(Transaction.Type.READ_WRITE, Collections.emptySet());
        }
        return this.openTransaction(tx.type(), Collections.emptySet());
    }

    public Transaction openTransaction(Transaction.Type type, Iterable<String> bookmarks) {
        if (this.currentThreadLocalTransaction.get() == null) {
            this.currentThreadLocalTransaction.set(this.transactionFactory.apply(type, bookmarks));
        } else {
            ((AbstractTransaction)this.currentThreadLocalTransaction.get()).extend(type);
        }
        return this.currentThreadLocalTransaction.get();
    }

    public void rollback(Transaction transaction) {
        this.checkIfCurrentAndRemove(transaction, tx -> {
            List newlyRegisteredObjects = tx.registeredNew();
            for (Object object : newlyRegisteredObjects) {
                ((Neo4jSession)this.session).context().reset(object);
            }
            newlyRegisteredObjects.clear();
        });
    }

    public void commit(Transaction transaction) {
        this.checkIfCurrentAndRemove(transaction, tx -> {
            List newlyRegisteredObjects = tx.registeredNew();
            newlyRegisteredObjects.clear();
        });
    }

    private void checkIfCurrentAndRemove(Transaction transaction, Consumer<AbstractTransaction> action) {
        if (transaction != this.getCurrentTransaction()) {
            throw new TransactionManagerException("Transaction is not current for this thread");
        }
        if (transaction instanceof AbstractTransaction) {
            action.accept((AbstractTransaction)transaction);
        }
        this.currentThreadLocalTransaction.remove();
    }

    public Transaction getCurrentTransaction() {
        return this.currentThreadLocalTransaction.get();
    }

    public boolean canCommit() {
        AbstractTransaction tx = (AbstractTransaction)this.getCurrentTransaction();
        if (tx == null) {
            return false;
        }
        return tx.extensions() == 0L && (tx.status() == Transaction.Status.COMMIT_PENDING || tx.status() == Transaction.Status.OPEN || tx.status() == Transaction.Status.PENDING);
    }

    public boolean canRollback() {
        AbstractTransaction tx = (AbstractTransaction)this.getCurrentTransaction();
        if (tx == null) {
            return false;
        }
        return tx.extensions() == 0L && (tx.status() == Transaction.Status.ROLLBACK_PENDING || tx.status() == Transaction.Status.COMMIT_PENDING || tx.status() == Transaction.Status.OPEN || tx.status() == Transaction.Status.PENDING);
    }

    public void bookmark(String bookmark) {
        if (this.session != null) {
            this.session.withBookmark(bookmark);
        }
    }
}

