/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.cron4j;

import it.sauronsoftware.cron4j.Task;
import org.noear.solon.XApp;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XProperties;
import org.noear.solon.extend.cron4j.Job;
import org.noear.solon.extend.cron4j.JobManager;

public class XPluginImp
implements XPlugin {
    public void start(XApp app) {
        JobManager.init();
        Aop.factory().beanCreatorAdd(Job.class, (clz, bw, anno) -> {
            String cron4x = anno.cron4x();
            if (anno.enable()) {
                this.scheduleAdd(cron4x, bw);
            }
        });
        Aop.beanOnloaded(() -> {
            Aop.beanForeach((k, bw) -> {
                if (k.startsWith("job:") && k.length() > 5) {
                    String key = k.split(":")[1];
                    XProperties prop = XApp.cfg().getProp("solon.schedule." + key);
                    if (prop.size() > 0) {
                        String cron4x = prop.getProperty("cron4x");
                        String enable = prop.getProperty("enable");
                        if ("false".equals(enable)) {
                            return;
                        }
                        this.scheduleAdd(cron4x, (BeanWrap)bw);
                    }
                }
            });
            JobManager.start();
        });
    }

    private void scheduleAdd(String cron4x, BeanWrap bw) {
        if (Runnable.class.isAssignableFrom(bw.clz())) {
            JobManager.addJob(cron4x, (Runnable)bw.raw());
        }
        if (Task.class.isAssignableFrom(bw.clz())) {
            if (cron4x.indexOf(" ") < 0) {
                throw new RuntimeException("Job only supported Runnable\uff1a" + bw.clz().getName());
            }
            JobManager.addTask(cron4x, (Task)bw.raw());
        }
    }

    public void stop() throws Throwable {
        JobManager.stop();
    }
}

