/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx.plus;

import org.noear.redisx.RedisClient;

public class RedisAtomic {
    private final RedisClient client;
    private final String atomicName;

    public RedisAtomic(RedisClient client, String atomicName) {
        this.client = client;
        this.atomicName = atomicName;
    }

    public long get() {
        return this.client.openAndGet(s -> s.key(this.atomicName).getAsLong());
    }

    public long increment() {
        return this.client.openAndGet(s -> s.key(this.atomicName).persist().incr());
    }

    public long incrementBy(long num) {
        return this.client.openAndGet(s -> s.key(this.atomicName).persist().incr(num));
    }

    public long decrement() {
        return this.client.openAndGet(s -> s.key(this.atomicName).persist().decr());
    }

    public long decrementBy(long num) {
        return this.client.openAndGet(s -> s.key(this.atomicName).persist().incr(-num));
    }
}

