/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx.plus;

import java.util.Collection;
import java.util.List;
import org.noear.redisx.RedisClient;

public class RedisList {
    private final RedisClient client;
    private final String listName;

    public RedisList(RedisClient client, String listName) {
        this.client = client;
        this.listName = listName;
    }

    public boolean remove(String element) {
        this.client.openAndGet(s -> s.key(this.listName).listDel(element));
        return true;
    }

    public String removeAt(int index) {
        int aryIndex = -index - 1;
        return this.client.openAndGet(s -> {
            String element = s.key(this.listName).listGet(aryIndex);
            if (element != null) {
                s.listDel(element);
            }
            return element;
        });
    }

    public boolean removeAll(Collection<? extends String> c) {
        this.client.openAndGet(s -> s.key(this.listName).listDelRange(c));
        return true;
    }

    public String get(int index) {
        int aryIndex = -index - 1;
        return this.client.openAndGet(s -> s.key(this.listName).listGet(aryIndex));
    }

    public List<String> getRange(int fromIndex, int toIndex) {
        int aryFromIndex = -fromIndex - 1;
        int aryToIndex = -toIndex - 1;
        return this.client.openAndGet(s -> s.key(this.listName).listGetRange(aryFromIndex, aryToIndex));
    }

    public List<String> getAll() {
        return this.client.openAndGet(s -> s.key(this.listName).listGetAll());
    }

    public void set(int index, String newValue) {
        this.client.open(s -> s.key(this.listName).listSet(index, newValue));
    }

    public boolean add(String element) {
        this.client.openAndGet(s -> s.key(this.listName).listAdd(element));
        return true;
    }

    public boolean addAll(Collection<? extends String> elements) {
        this.client.open(s -> s.key(this.listName).listAddRange(elements));
        return true;
    }

    public long size() {
        return this.client.openAndGet(s -> s.key(this.listName).listLen());
    }

    public void clear() {
        this.client.open(s -> s.key(this.listName).delete());
    }
}

