/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.dubbo;

import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import java.util.Properties;
import org.nutz.integration.dubbo.AnnotationBean;
import org.nutz.integration.dubbo.DubboAgent;
import org.nutz.integration.dubbo.DubboIocLoader;
import org.nutz.integration.dubbo.DubboManager;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.Iocs;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.meta.IocObject;
import org.nutz.lang.Strings;

public class DubboConfigIocLoader
extends DubboIocLoader {
    protected Ioc ioc;
    protected PropertiesProxy conf;

    public DubboConfigIocLoader(Ioc ioc, PropertiesProxy conf) {
        this.ioc = ioc;
        this.conf = conf;
        this.init();
    }

    protected void init() {
        this.conf.putIfAbsent((Object)"dubbo.application.name", (Object)this.conf.get("nutz.application.name", "demo"));
        this.conf.putIfAbsent((Object)"dubbo.registry.address", (Object)"multicast://224.5.6.7:1234");
        this.conf.putIfAbsent((Object)"dubbo.protocol.name", (Object)"dubbo");
        this.conf.putIfAbsent((Object)"dubbo.protocol.port", (Object)"20880");
        ConfigUtils.addProperties((Properties)this.conf.toProperties());
        this.iobjs.put("dubbo_iobjs", Iocs.wrap((Object)this.iobjs));
        this.wrap("dubboManager", new DubboManager());
        this.prepareApplicationConfig();
        this.prepareProtocolConfig();
        this.prepareRegistryConfig();
        this.prepareAnnotationBean();
    }

    protected void prepareApplicationConfig() {
        ApplicationConfig applicationConfig = (ApplicationConfig)this.conf.make(ApplicationConfig.class, "dubbo.application.");
        this.wrap("dubboApplicationConfig", applicationConfig);
    }

    protected void prepareRegistryConfig() {
        RegistryConfig registryConfig = (RegistryConfig)this.conf.make(RegistryConfig.class, "dubbo.registry.");
        this.wrap("dubboRegistryConfig", registryConfig);
    }

    protected void prepareProtocolConfig() {
        ProtocolConfig protocolConfig = (ProtocolConfig)this.conf.make(ProtocolConfig.class, "dubbo.protocol.");
        this.wrap("dubboPrototeConfig", protocolConfig);
    }

    protected void prepareAnnotationBean() {
        String propName = "dubbo.scan.basePackages";
        String beanName = "dubboAnnotationBean";
        AnnotationBean annos = new AnnotationBean();
        annos.setPackages(Strings.splitIgnoreBlank((String)this.conf.get(propName)));
        this.wrap(beanName, annos);
    }

    protected void wrap(String beanName, Object iocBean) {
        IocObject iobj = Iocs.wrap((Object)iocBean);
        DubboAgent.checkIocObject(beanName, iobj);
        this.iobjs.put(beanName, iobj);
    }
}

