/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.dubbo;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Xmls;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DubboConfigureReader {
    private static final Log log = Logs.get();
    protected Map<String, Object> maps = new HashMap<String, Object>();

    public static Map<String, NutMap> read(String path) {
        LinkedHashMap<String, NutMap> maps = new LinkedHashMap<String, NutMap>();
        Document doc = Xmls.xml((InputStream)DubboConfigureReader.class.getClassLoader().getResourceAsStream(path));
        doc.normalizeDocument();
        Element top = doc.getDocumentElement();
        NodeList list = top.getChildNodes();
        int count = list.getLength();
        for (int i = 0; i < count; ++i) {
            Element ele;
            String eleName;
            Node node = list.item(i);
            if (!(node instanceof Element) || !(eleName = (ele = (Element)node).getNodeName()).startsWith("dubbo:")) continue;
            String typeName = eleName.substring("dubbo:".length());
            NutMap attrs = DubboConfigureReader.toAttrMap(ele.getAttributes());
            log.debug((Object)("found " + typeName));
            String genBeanName = ele.getAttribute("id");
            if (Strings.isBlank((CharSequence)genBeanName)) {
                if ("protocol".equals(typeName)) {
                    genBeanName = "dubbo";
                } else {
                    genBeanName = ele.getAttribute("interface");
                    if (Strings.isBlank((CharSequence)genBeanName)) {
                        try {
                            genBeanName = Class.forName("com.alibaba.dubbo.config." + Strings.upperFirst((CharSequence)typeName) + "Config").getName();
                        }
                        catch (ClassNotFoundException e) {
                            throw Lang.wrapThrow((Throwable)e);
                        }
                    }
                }
                if (maps.containsKey(genBeanName)) {
                    String key;
                    int _count = 2;
                    while (maps.containsKey(key = genBeanName + "_" + _count)) {
                        ++_count;
                    }
                    genBeanName = genBeanName + "_" + _count;
                }
            }
            attrs.put((Object)"_typeName", (Object)typeName);
            maps.put(genBeanName, attrs);
        }
        return maps;
    }

    public static NutMap toAttrMap(NamedNodeMap attrs) {
        NutMap map = new NutMap();
        int len = attrs.getLength();
        for (int j = 0; j < len; ++j) {
            Attr attr = (Attr)attrs.item(j);
            map.put((Object)attr.getName(), (Object)attr.getValue());
        }
        return map;
    }
}

