/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.nutz.boot.config.ConfigureLoader;
import org.nutz.boot.env.EnvHolder;
import org.nutz.boot.resource.ResourceLoader;
import org.nutz.boot.starter.ServerFace;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.combo.ComboIocLoader;
import org.nutz.lang.util.LifeCycle;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class AppContext
implements LifeCycle {
    private static final Log log = Logs.get();
    protected static AppContext _default = new AppContext();
    protected Ioc ioc;
    protected ClassLoader classLoader;
    protected ConfigureLoader configureLoader;
    protected ResourceLoader resourceLoader;
    protected EnvHolder envHolder;
    protected ComboIocLoader comboIocLoader;
    protected Class<?> mainClass;
    protected String mainPackage;
    protected List<Object> starters = new ArrayList<Object>();
    protected String basePath;
    protected List<ServerFace> serverFaces = new LinkedList<ServerFace>();

    public Ioc ioc() {
        return this.ioc;
    }

    public Ioc getIoc() {
        return this.ioc;
    }

    public void setIoc(Ioc ioc) {
        this.ioc = ioc;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ConfigureLoader getConfigureLoader() {
        return this.configureLoader;
    }

    public PropertiesProxy getConf() {
        return this.configureLoader.get();
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public EnvHolder getEnvHolder() {
        return this.envHolder;
    }

    public void setEnvHolder(EnvHolder envHolder) {
        this.envHolder = envHolder;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setConfigureLoader(ConfigureLoader configureLoader) {
        this.configureLoader = configureLoader;
    }

    public static AppContext getDefault() {
        return _default;
    }

    public static void setDefault(AppContext ctx) {
        _default = ctx;
    }

    public void setComboIocLoader(ComboIocLoader comboIocLoader) {
        this.comboIocLoader = comboIocLoader;
    }

    public ComboIocLoader getComboIocLoader() {
        return this.comboIocLoader;
    }

    public List<Object> getStarters() {
        return this.starters;
    }

    public void addStarter(Object obj) {
        this.starters.add(obj);
    }

    public Class<?> getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(Class<?> mainClass) {
        this.mainClass = mainClass;
    }

    public void setMainPackage(String mainPackage) {
        this.mainPackage = mainPackage;
    }

    public String getPackage() {
        return this.mainPackage == null ? this.mainClass.getPackage().getName() : this.mainPackage;
    }

    public void init() throws Exception {
        for (Object object : this.starters) {
            if (!(object instanceof LifeCycle)) continue;
            ((LifeCycle)object).init();
        }
    }

    public void fetch() throws Exception {
    }

    public void depose() throws Exception {
        for (Object object : this.starters) {
            if (!(object instanceof LifeCycle)) continue;
            ((LifeCycle)object).depose();
        }
        if (this.ioc != null) {
            this.ioc.depose();
        }
    }

    public void startServers() throws Exception {
        for (ServerFace face : this.getBeans(ServerFace.class)) {
            this.serverFaces.add(face);
            face.start();
        }
    }

    public void stopServers() throws Exception {
        for (ServerFace face : this.serverFaces) {
            face.stop();
        }
    }

    public <T> List<T> getBeans(Class<T> klass) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String name : this.getIoc().getNamesByType(klass)) {
            if (name == null) continue;
            list.add(this.getIoc().get(klass, name));
        }
        return list;
    }

    public int getServerPort(String legacyKey) {
        return this.getServerPort(legacyKey, 8080);
    }

    public int getServerPort(String legacyKey, int defaultValue) {
        if (legacyKey != null && this.getConf().has(legacyKey)) {
            int port = this.getConf().getInt(legacyKey);
            if (port < 1) {
                port = new Random(System.currentTimeMillis()).nextInt(10000) + defaultValue;
                log.debugf("select random port=%d for %s", new Object[]{port, legacyKey});
                this.getConf().put(legacyKey, "" + port);
            }
            return port;
        }
        int port = this.getConf().getInt("server.port", defaultValue);
        if (port == 0) {
            port = new Random(System.currentTimeMillis()).nextInt(10000) + defaultValue;
            this.getConf().set("server.port", "" + port);
            log.debugf("select random port=%d for %s and server.port", new Object[]{port, legacyKey});
        }
        return port;
    }

    public String getServerHost(String legacyKey) {
        if (legacyKey != null && this.getConf().has(legacyKey)) {
            return this.getConf().get(legacyKey);
        }
        return this.getConf().get("server.host", "0.0.0.0");
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        if (this.basePath == null) {
            try {
                this.basePath = this.getMainClass().getProtectionDomain().getCodeSource().getLocation().getPath();
                int lastIndex = this.basePath.lastIndexOf(47);
                if (lastIndex < 0) {
                    lastIndex = this.basePath.lastIndexOf(92);
                }
                this.basePath = this.basePath.substring(0, lastIndex);
                this.basePath = URLDecoder.decode(this.basePath, "UTF-8");
            }
            catch (Throwable e) {
                this.basePath = ".";
            }
        }
        return this.basePath;
    }
}

