/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.config.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.nutz.boot.config.impl.AbstractConfigureLoader;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Disks;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class PropertiesConfigureLoader
extends AbstractConfigureLoader {
    private static final Log log = Logs.get();

    public void init() throws Exception {
        InputStream ins;
        Object tmp;
        boolean flag;
        String path;
        block22: {
            path = this.envHolder.get("nutz.boot.configure.properties_path", "application.properties");
            this.conf.setPaths(new String[]{"custom/"});
            flag = true;
            try {
                tmp = new File(this.getPath(path));
                if (!((File)tmp).exists() || !((File)tmp).canRead()) break block22;
                ins = new FileInputStream((File)tmp);
                Throwable throwable = null;
                try {
                    log.debugf("load %s", new Object[]{((File)tmp).getAbsolutePath()});
                    this.conf.load(Streams.utf8r((InputStream)ins), false);
                    flag = false;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ins != null) {
                        if (throwable != null) {
                            try {
                                ((FileInputStream)ins).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FileInputStream)ins).close();
                        }
                    }
                }
            }
            catch (Throwable tmp2) {
                // empty catch block
            }
        }
        if (flag) {
            this.readPropertiesPath(path);
        }
        tmp = new PropertiesProxy();
        if (this.args != null) {
            this.parseCommandLineArgs((PropertiesProxy)tmp, this.args);
            if (tmp.has("nutz.profiles.active")) {
                this.conf.put("nutz.profiles.active", tmp.remove((Object)"nutz.profiles.active"));
            }
        }
        if (this.allowCommandLineProperties) {
            this.conf.putAll((Map)System.getProperties());
        }
        if (this.conf.has("nutz.profiles.active")) {
            String profile = this.conf.get("nutz.profiles.active");
            String _path = path.substring(0, path.lastIndexOf(46)) + "-" + profile + ".properties";
            this.readPropertiesPath(_path);
        }
        if (this.conf.has("nutz.boot.configure.properties.dir")) {
            String configDir = this.conf.get("nutz.boot.configure.properties.dir");
            String configPath = this.getPath(configDir);
            Disks.visitFile((String)configPath, (String)".+properties$", (boolean)true, file -> {
                if (file.canRead()) {
                    try (FileInputStream ins = new FileInputStream(file);){
                        this.conf.load(Streams.utf8r((InputStream)ins), false);
                    }
                    catch (IOException e) {
                        log.info((Object)("fail to load " + file.getAbsolutePath()));
                    }
                }
            });
        }
        if (tmp.size() > 0) {
            this.conf.putAll(tmp.toMap());
        }
        if (Strings.isBlank((CharSequence)this.conf.get("app.build.version")) && (ins = this.resourceLoader.get("build.version")) != null) {
            this.conf.load((Reader)new InputStreamReader(ins), false);
        }
    }

    protected String getPath(String ... names) {
        String path2;
        String path;
        File f;
        String tmp = Strings.join((String)File.separator, (Object[])names);
        if (tmp.endsWith("/")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if ((f = new File(tmp)).exists() && (path = Disks.getCanonicalPath((String)tmp)).equals(path2 = Disks.getCanonicalPath((String)f.getAbsolutePath()))) {
            return tmp;
        }
        return this.appContext.getBasePath() + File.separator + tmp;
    }

    protected void readPropertiesPath(String path) throws IOException {
        try (InputStream ins = this.resourceLoader.get(path);){
            if (ins != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading Properties  - " + path));
                }
                this.conf.load(Streams.utf8r((InputStream)ins), false);
            } else if (log.isInfoEnabled()) {
                log.info((Object)("Properties NotFound - " + path));
            }
        }
    }
}

