/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.resource.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nutz.boot.aware.ClassLoaderAware;
import org.nutz.boot.resource.ResourceLoader;

public class SimpleResourceLoader
implements ResourceLoader,
ClassLoaderAware {
    protected ClassLoader classLoader;

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean has(String path) {
        File f = new File(path);
        if (f.exists()) {
            return true;
        }
        if (this.classLoader != null) {
            return this.classLoader.getResource(path) != null;
        }
        return this.getClass().getClassLoader().getResource(path) != null;
    }

    @Override
    public InputStream get(String path) throws IOException {
        File f = new File(path);
        if (f.exists() && f.canRead()) {
            return new FileInputStream(f);
        }
        if (this.classLoader != null) {
            return this.classLoader.getResourceAsStream(path);
        }
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }
}

