/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.sm2strut;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;

public class IssuerAndSerialNumber
extends ASN1Object {
    private X500Name name;
    private ASN1Integer certSerialNumber;

    public IssuerAndSerialNumber(X500Name name, ASN1Integer certSerialNumber) {
        this.name = name;
        this.certSerialNumber = certSerialNumber;
    }

    public IssuerAndSerialNumber(ASN1Sequence seq) {
        this.name = X500Name.getInstance((Object)seq.getObjectAt(0));
        this.certSerialNumber = ASN1Integer.getInstance((Object)seq.getObjectAt(1));
    }

    public static IssuerAndSerialNumber getInstance(Object o) {
        if (o instanceof IssuerAndSerialNumber) {
            return (IssuerAndSerialNumber)((Object)o);
        }
        if (o != null) {
            return new IssuerAndSerialNumber(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public X500Name getName() {
        return this.name;
    }

    public IssuerAndSerialNumber setName(X500Name name) {
        this.name = name;
        return this;
    }

    public ASN1Integer getCertSerialNumber() {
        return this.certSerialNumber;
    }

    public IssuerAndSerialNumber setCertSerialNumber(ASN1Integer certSerialNumber) {
        this.certSerialNumber = certSerialNumber;
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add((ASN1Encodable)this.name);
        v.add((ASN1Encodable)this.certSerialNumber);
        return new DERSequence(v);
    }
}

