/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import org.ofdrw.layout.element.Div;

public class Img
extends Div {
    private Path src;

    private Img() {
        this.setIntegrity(true);
    }

    public Img(double width, double height, Path src) throws IOException {
        this(src);
        this.setWidth(width).setHeight(height);
    }

    public Img(Path src) throws IOException {
        this();
        if (src == null || Files.notExists(src, new LinkOption[0])) {
            throw new IllegalArgumentException("\u56fe\u7247\u6587\u4ef6\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
        }
        this.src = src;
        this.parseImg();
    }

    private void parseImg() throws IOException {
        File picture = this.src.toFile();
        try (FileInputStream fIn = new FileInputStream(picture);){
            BufferedImage sourceImg = ImageIO.read(fIn);
            this.setWidth((double)sourceImg.getWidth() / 5.0);
            this.setHeight((double)sourceImg.getHeight() / 5.0);
        }
    }

    public Path getSrc() {
        return this.src;
    }

    public Img setSrc(Path src) {
        this.src = src;
        return this;
    }

    @Override
    public Div[] split(double sHeight) {
        throw new RuntimeException("\u56fe\u7247\u5bf9\u8c61\u4e0d\u652f\u6301\u5206\u5272\u64cd\u4f5c");
    }
}

