/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element;

import java.util.Arrays;
import org.ofdrw.layout.Rectangle;
import org.ofdrw.layout.RenderPrepare;
import org.ofdrw.layout.element.AFloat;
import org.ofdrw.layout.element.ArrayParamTool;
import org.ofdrw.layout.element.Clear;
import org.ofdrw.layout.element.Position;
import org.ofdrw.layout.engine.ElementSplit;

public class Div
implements RenderPrepare,
ElementSplit {
    private int[] backgroundColor = null;
    private int[] borderColor = null;
    private Double width = null;
    private Double height = null;
    private Double[] padding = new Double[]{0.0, 0.0, 0.0, 0.0};
    private Double[] border = new Double[]{0.0, 0.0, 0.0, 0.0};
    private Double[] margin = new Double[]{0.0, 0.0, 0.0, 0.0};
    private Double x = null;
    private Double y = null;
    private Clear clear = Clear.both;
    private AFloat aFloat = AFloat.left;
    private double left = 0.0;
    private double right = 0.0;
    private double top = 0.0;
    private Double opacity = null;
    private Position position = Position.Static;
    private Boolean integrity = false;
    private boolean placeholder = false;

    public Div() {
    }

    public Div(Double width, Double height) {
        this.width = width;
        this.height = height;
    }

    public boolean isNoBorder() {
        return this.getBorderTop() == 0.0 && this.getBorderRight() == 0.0 && this.getBorderBottom() == 0.0 && this.getBorderLeft() == 0.0;
    }

    public boolean isBlockElement() {
        if (this.position == Position.Absolute) {
            return false;
        }
        return this.clear == Clear.both || this.aFloat == AFloat.right && this.clear == Clear.left || this.aFloat == AFloat.left && this.clear == Clear.right;
    }

    public Double getOpacity() {
        return this.opacity;
    }

    public Div setOpacity(Double opacity) {
        if (opacity != null) {
            if (opacity > 1.0) {
                opacity = 1.0;
            } else if (opacity < 0.0) {
                opacity = 0.0;
            }
        }
        this.opacity = opacity;
        return this;
    }

    public int[] getBorderColor() {
        return this.borderColor;
    }

    public Div setBorderColor(int r, int g, int b) {
        this.borderColor = new int[]{r, g, b};
        return this;
    }

    Div setBorderColor(int[] rgb) {
        this.borderColor = rgb;
        return this;
    }

    public Double getTop() {
        return this.top;
    }

    public Div setTop(Double top) {
        this.top = top;
        return this;
    }

    public Position getPosition() {
        return this.position;
    }

    public Div setPosition(Position position) {
        this.position = position;
        return this;
    }

    public int[] getBackgroundColor() {
        return this.backgroundColor;
    }

    public Div setBackgroundColor(int r, int g, int b) {
        this.backgroundColor = new int[]{r, g, b};
        return this;
    }

    Div setBackgroundColor(int[] backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public Double getWidth() {
        return this.width;
    }

    public Div setWidth(Double width) {
        this.width = width;
        return this;
    }

    public Double getHeight() {
        return this.height;
    }

    public Div setHeight(Double height) {
        this.height = height;
        return this;
    }

    public Double[] getPadding() {
        return this.padding;
    }

    public Div setPadding(Double ... padding) {
        this.padding = ArrayParamTool.arr4p(padding);
        return this;
    }

    public Double[] getBorder() {
        return this.border;
    }

    public Div setBorder(Double ... border) {
        this.border = ArrayParamTool.arr4p(border);
        return this;
    }

    public Double[] getMargin() {
        return this.margin;
    }

    public Div setMargin(Double ... margin) {
        this.margin = ArrayParamTool.arr4p(margin);
        return this;
    }

    public Double getMarginTop() {
        return this.margin[0];
    }

    public Div setMarginTop(Double top) {
        this.margin[0] = top;
        return this;
    }

    public Double getMarginRight() {
        return this.margin[1];
    }

    public Div setMarginRight(Double right) {
        this.margin[1] = right;
        return this;
    }

    public Double getMarginBottom() {
        return this.margin[2];
    }

    public Div setMarginBottom(Double bottom) {
        this.margin[2] = bottom;
        return this;
    }

    public Double getMarginLeft() {
        return this.margin[3];
    }

    public Div setMarginLeft(Double left) {
        this.margin[3] = left;
        return this;
    }

    public Double getBorderTop() {
        return this.border[0];
    }

    public Div setBorderTop(Double top) {
        this.border[0] = top;
        return this;
    }

    public Double getBorderRight() {
        return this.border[1];
    }

    public Div setBorderRight(Double right) {
        this.border[1] = right;
        return this;
    }

    public Double getBorderBottom() {
        return this.border[2];
    }

    public Div setBorderBottom(Double bottom) {
        this.border[2] = bottom;
        return this;
    }

    public Double getBorderLeft() {
        return this.border[3];
    }

    public Div setBorderLeft(Double left) {
        this.border[3] = left;
        return this;
    }

    public Double getPaddingTop() {
        return this.padding[0];
    }

    public Div setPaddingTop(Double top) {
        this.padding[0] = top;
        return this;
    }

    public Double getPaddingRight() {
        return this.padding[1];
    }

    public Div setPaddingRight(Double right) {
        this.padding[1] = right;
        return this;
    }

    public Double getPaddingBottom() {
        return this.padding[2];
    }

    public Div setPaddingBottom(Double bottom) {
        this.padding[2] = bottom;
        return this;
    }

    public Double getPaddingLeft() {
        return this.padding[3];
    }

    public Div setPaddingLeft(Double left) {
        this.padding[3] = left;
        return this;
    }

    public Double getX() {
        return this.x;
    }

    public Div setX(Double x) {
        this.x = x;
        return this;
    }

    public Double getY() {
        return this.y;
    }

    public Div setY(Double y) {
        this.y = y;
        return this;
    }

    public Clear getClear() {
        return this.clear;
    }

    public Div setClear(Clear clear) {
        this.clear = clear;
        return this;
    }

    public AFloat getFloat() {
        return this.aFloat;
    }

    public Div setFloat(AFloat aFloat) {
        this.aFloat = aFloat;
        return this;
    }

    public Double getLeft() {
        return this.left;
    }

    public Div setLeft(Double left) {
        this.left = left;
        return this;
    }

    public Double getRight() {
        return this.right;
    }

    public Div setRight(Double right) {
        this.right = right;
        return this;
    }

    public Boolean isIntegrity() {
        return this.integrity;
    }

    public Div setIntegrity(Boolean integrity) {
        this.integrity = integrity;
        return this;
    }

    public double widthPlus() {
        return this.margin[1] + this.margin[3] + (this.padding[1] + this.padding[3]) + (this.border[1] + this.border[3]);
    }

    public double heightPlus() {
        return this.margin[0] + this.margin[2] + (this.padding[0] + this.padding[2]) + (this.border[0] + this.border[2]);
    }

    @Override
    public Rectangle doPrepare(Double widthLimit) {
        if (this.height == null || this.width == null) {
            return Rectangle.Empty;
        }
        if (widthLimit == null) {
            throw new NullPointerException("widthLimit\u4e3a\u7a7a");
        }
        widthLimit = widthLimit - this.widthPlus();
        if (this.width > widthLimit) {
            this.setWidth(widthLimit);
        }
        double w = this.width + this.widthPlus();
        double h = this.height + this.heightPlus();
        return new Rectangle(w, h);
    }

    public Rectangle box() {
        double w = this.width + this.widthPlus();
        double h = this.height + this.heightPlus();
        return new Rectangle(w, h);
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public Div setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public static Div placeholder(double width, double height, AFloat aFloat) {
        return new Div().setPlaceholder(true).setWidth(width).setHeight(height).setFloat(aFloat).setClear(Clear.none).setIntegrity(true);
    }

    public static Div placeholder(Rectangle rec, AFloat aFloat) {
        return Div.placeholder(rec.getWidth(), rec.getHeight(), aFloat);
    }

    public Div clone() {
        Div div = new Div();
        return this.copyTo(div);
    }

    public <T extends Div> T copyTo(T div) {
        div.setBackgroundColor(this.backgroundColor == null ? null : (int[])this.backgroundColor.clone());
        div.setBorderColor(this.borderColor == null ? null : (int[])this.borderColor.clone());
        div.setWidth(this.width);
        div.setHeight(this.height);
        div.setPadding((Double[])this.padding.clone());
        div.setBorder((Double[])this.border.clone());
        div.setMargin((Double[])this.margin.clone());
        div.setX(this.x);
        div.setY(this.y);
        div.setClear(this.clear);
        div.setFloat(this.aFloat);
        div.setLeft(this.left);
        div.setRight(this.right);
        div.setTop(this.top);
        div.setPosition(this.position);
        div.setIntegrity(this.integrity);
        div.setPlaceholder(this.placeholder);
        return div;
    }

    @Override
    public Div[] split(double sHeight) {
        if (this.width == null || this.height == null) {
            throw new RuntimeException("\u5207\u5206\u5143\u7d20\u5fc5\u987b\u8981\u6709\u56fa\u5b9a\u7684\u5bbd\u5ea6\uff08width\uff09\u548c\u9ad8\u5ea6\uff08height\uff09");
        }
        double totalH = this.height + this.heightPlus();
        if (totalH <= sHeight) {
            return new Div[]{this};
        }
        Div div1 = this.clone();
        Div div2 = this.clone();
        if (this.getMarginTop() >= sHeight) {
            double deltaM = this.getMarginTop() - sHeight;
            div1.setMarginTop(sHeight).setBorderTop(0.0).setPaddingTop(0.0).setHeight(0.0).setPaddingBottom(0.0).setBorderBottom(0.0).setMarginBottom(0.0).setPlaceholder(true);
            div2.setMarginTop(deltaM);
        } else if (this.getMarginTop() + this.getBorderTop() >= sHeight) {
            double deltaB = this.getBorderTop() - (sHeight - this.getMarginTop());
            div1.setBorderTop(sHeight - this.getMarginTop()).setPaddingTop(0.0).setHeight(0.0).setPaddingBottom(0.0).setBorderBottom(0.0).setMarginBottom(0.0);
            div2.setMarginTop(0.0).setBorderTop(deltaB);
        } else if (this.getMarginTop() + this.getBorderTop() + this.getPaddingTop() >= sHeight) {
            double deltaP = this.getPaddingTop() - (sHeight - this.getMarginTop() - this.getBorderTop());
            div1.setPaddingTop(sHeight - this.getMarginTop() - this.getBorderTop()).setHeight(0.0).setPaddingBottom(0.0).setMarginBottom(0.0);
            div2.setMarginTop(0.0).setBorderTop(0.0).setPaddingTop(deltaP);
        } else if (this.getMarginTop() + this.getBorderTop() + this.getPaddingTop() + this.getHeight() >= sHeight) {
            Div[] divs = this.contentSplitAdjust(sHeight, div1, div2);
            div1 = divs[0];
            div2 = divs[1];
        } else if (this.getMarginTop() + this.getBorderTop() + this.getPaddingTop() + this.getHeight() + this.getPaddingBottom() >= sHeight) {
            double deltaP = sHeight - (this.getMarginTop() + this.getBorderTop() + this.getPaddingTop() + this.getHeight());
            div1.setPaddingBottom(deltaP).setBorderBottom(0.0).setMarginBottom(0.0);
            div2.setMarginTop(0.0).setBorderTop(0.0).setPaddingTop(0.0).setHeight(0.0).setPaddingBottom(div2.getPaddingBottom() - deltaP);
        } else if (this.getMarginTop() + this.getBorderTop() + this.getPaddingTop() + this.getHeight() + this.getPaddingBottom() + this.getBorderBottom() >= sHeight) {
            double deltaB = sHeight - (this.getMarginTop() + this.getBorderTop() + this.getPaddingTop() + this.getHeight() + this.getPaddingBottom());
            div1.setBorderBottom(deltaB).setMarginBottom(0.0);
            div2.setMarginTop(0.0).setBorderTop(0.0).setPaddingTop(0.0).setHeight(0.0).setPaddingBottom(0.0).setBorderBottom(div2.getBorderBottom() - deltaB);
        } else {
            double deltaM = sHeight - (this.getMarginTop() + this.getBorderTop() + this.getPaddingTop() + this.getHeight() + this.getPaddingBottom() + this.getBorderBottom());
            div1.setMarginBottom(deltaM);
            div2.setMarginTop(0.0).setBorderTop(0.0).setPaddingTop(0.0).setHeight(0.0).setPaddingBottom(0.0).setBorderBottom(0.0).setMarginBottom(div2.getMarginBottom() - deltaM).setPlaceholder(true);
        }
        return new Div[]{div1, div2};
    }

    public <T extends Div> Div[] contentSplitAdjust(double sHeight, T div1, T div2) {
        double h1 = sHeight - (div1.getMarginTop() + div1.getBorderTop() + div1.getPaddingTop());
        div1.setHeight(h1).setMarginBottom(0.0).setBorderBottom(0.0).setPaddingBottom(0.0);
        double h2 = div2.getHeight() - h1;
        div2.setHeight(h2).setMarginTop(0.0).setBorderTop(0.0).setPaddingTop(0.0);
        return new Div[]{div1, div2};
    }

    public String toString() {
        return "Div{backgroundColor=" + Arrays.toString(this.backgroundColor) + ", borderColor=" + Arrays.toString(this.borderColor) + ", width=" + this.width + ", height=" + this.height + ", padding=" + Arrays.toString((Object[])this.padding) + ", border=" + Arrays.toString((Object[])this.border) + ", margin=" + Arrays.toString((Object[])this.margin) + ", x=" + this.x + ", y=" + this.y + ", clear=" + (Object)((Object)this.clear) + ", aFloat=" + (Object)((Object)this.aFloat) + ", left=" + this.left + ", right=" + this.right + ", top=" + this.top + ", position=" + (Object)((Object)this.position) + ", integrity=" + this.integrity + ", placeholder=" + this.placeholder + '}';
    }
}

