/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element.canvas;

import java.awt.geom.AffineTransform;
import java.nio.file.Path;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.pageDescription.color.pattern.CT_Pattern;
import org.ofdrw.core.pageDescription.color.pattern.CellContent;
import org.ofdrw.core.pageDescription.color.pattern.ReflectMethod;

public class CanvasPattern {
    public final CT_Pattern pattern = new CT_Pattern();
    public final Path img;
    public final ImageObject imgObj;

    public CanvasPattern(Path img, String repetition, ImageObject imgObj) {
        this.img = img.toAbsolutePath();
        this.imgObj = imgObj;
        switch (repetition.toLowerCase()) {
            case "repeat": 
            case "": {
                break;
            }
            case "column": {
                this.pattern.setReflectMethod(ReflectMethod.Column);
                break;
            }
            case "row": {
                this.pattern.setReflectMethod(ReflectMethod.Row);
                break;
            }
            case "row-column": {
                this.pattern.setReflectMethod(ReflectMethod.RowAndColumn);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u91cd\u590d\u6837\u5f0f\uff1a" + repetition);
            }
        }
        CellContent cellContent = new CellContent();
        cellContent.addPageBlock((PageBlockType)imgObj);
        this.pattern.setCellContent(cellContent);
        ST_Box boundary = imgObj.getBoundary();
        this.pattern.setWidth(boundary.getWidth());
        this.pattern.setHeight(boundary.getHeight());
    }

    public void setTransform(double[] matrix) {
        if (matrix == null || matrix.length < 6) {
            throw new IllegalArgumentException("\u77e9\u9635\u53c2\u6570\u9519\u8bef");
        }
        ST_Array ctm = new ST_Array(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
        this.pattern.setCTM(ctm);
    }

    public void setTransform(AffineTransform tx) {
        if (tx == null) {
            throw new IllegalArgumentException("\u77e9\u9635\u53c2\u6570\u9519\u8bef");
        }
        ST_Array ctm = new ST_Array(tx.getScaleX(), tx.getShearY(), tx.getShearX(), tx.getScaleY(), tx.getTranslateX(), tx.getTranslateY());
        this.pattern.setCTM(ctm);
    }

    public void setImageSize(double w, double h) {
        this.pattern.setWidth(Double.valueOf(w));
        this.pattern.setHeight(Double.valueOf(h));
        this.imgObj.setBoundary(new ST_Box(0.0, 0.0, w, h));
        this.imgObj.setCTM(new ST_Array(w, 0.0, 0.0, h, 0.0, 0.0));
    }
}

