/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.engine.render;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicType.STBase;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.graph.pathObj.AbbreviatedData;
import org.ofdrw.core.graph.pathObj.CT_Path;
import org.ofdrw.core.pageDescription.CT_GraphicUnit;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.engine.GraphHelper;
import org.ofdrw.layout.engine.ResManager;
import org.ofdrw.layout.engine.render.Processor;
import org.ofdrw.layout.engine.render.RenderException;

public class DivRender
implements Processor {
    @Override
    public void render(ST_Loc pageLoc, CT_PageBlock layer, ResManager resManager, Div e, AtomicInteger maxUnitID) throws RenderException {
        DivRender.render(layer, e, maxUnitID);
    }

    public static void render(CT_PageBlock layer, Div<?> e, AtomicInteger maxUnitID) {
        int[] bgColor = e.getBackgroundColor();
        if (bgColor == null && e.isNoBorder()) {
            return;
        }
        Integer alpha = null;
        if (e.getOpacity() != null) {
            alpha = (int)(e.getOpacity() * 255.0);
        }
        if (e.getHeight() == null) {
            throw new IllegalArgumentException("Div\u5143\u7d20\u7684\u9ad8\u5ea6\u5fc5\u987b\u6307\u5b9a");
        }
        Double borderTop = e.getBorderTop();
        Double borderRight = e.getBorderRight();
        Double borderBottom = e.getBorderBottom();
        Double borderLeft = e.getBorderLeft();
        double eleContentHeight = e.getPaddingTop() + e.getHeight() + e.getPaddingBottom();
        if (bgColor != null && eleContentHeight > 0.0) {
            ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
            PathObject bg = new PathObject(objId);
            double x = e.getX() + e.getMarginLeft() + borderLeft;
            double y = e.getY() + e.getMarginTop() + borderTop;
            double w = e.getPaddingLeft() + e.getWidth() + e.getPaddingRight();
            ((CT_Path)bg.setBoundary(x, y, w, eleContentHeight)).setAbbreviatedData(GraphHelper.rect(0.0, 0.0, w, eleContentHeight)).setStroke(Boolean.valueOf(false)).setFill(Boolean.valueOf(true)).setFillColor(CT_Color.rgb((int[])bgColor));
            if (alpha != null) {
                bg.setAlpha(alpha);
            }
            layer.addPageBlock((PageBlockType)bg);
        }
        Double[] borderDash = e.getBorderDash();
        if (DivRender.eq(borderTop, borderRight, borderBottom, borderLeft)) {
            double lineWidth = borderTop;
            ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
            PathObject border = new PathObject(objId);
            double x = e.getX() + e.getMarginLeft();
            double y = e.getY() + e.getMarginTop();
            double w = lineWidth + e.getPaddingLeft() + e.getWidth() + e.getPaddingRight() + lineWidth;
            double h = lineWidth + e.getPaddingTop() + e.getHeight() + e.getPaddingBottom() + lineWidth;
            ((CT_Path)((CT_Path)border.setBoundary(x, y, w, h)).setLineWidth(Double.valueOf(lineWidth))).setAbbreviatedData(GraphHelper.rect(lineWidth / 2.0, lineWidth / 2.0, w - lineWidth, h - lineWidth));
            int[] borderColor = e.getBorderColor();
            if (borderColor != null) {
                border.setStrokeColor(CT_Color.rgb((int[])borderColor));
            }
            if (alpha != null) {
                border.setAlpha(alpha);
            }
            if (borderDash != null) {
                DivRender.setLineDash(border, borderDash);
            }
            layer.addPageBlock((PageBlockType)border);
        } else {
            double rightWidth;
            double bottomWidth;
            double ZERO;
            double topWidth = borderTop;
            if (topWidth > (ZERO = 1.0E-5)) {
                ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
                PathObject topBorder = new PathObject(objId);
                double x = e.getX() + e.getMarginLeft();
                double y = e.getY() + e.getMarginTop();
                double w = borderLeft + e.getPaddingLeft() + e.getWidth() + e.getPaddingRight() + borderRight;
                ((CT_Path)((CT_Path)topBorder.setBoundary(x, y, w, topWidth)).setLineWidth(Double.valueOf(topWidth))).setAbbreviatedData(new AbbreviatedData().M(0.0, topWidth / 2.0).L(w, topWidth / 2.0));
                int[] borderColor = e.getBorderColor();
                if (borderColor != null) {
                    topBorder.setStrokeColor(CT_Color.rgb((int[])borderColor));
                }
                if (alpha != null) {
                    topBorder.setAlpha(alpha);
                }
                if (borderDash != null) {
                    DivRender.setLineDash(topBorder, borderDash);
                }
                layer.addPageBlock((PageBlockType)topBorder);
            }
            if ((bottomWidth = borderBottom.doubleValue()) > ZERO) {
                ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
                PathObject bottomBorder = new PathObject(objId);
                double x = e.getX() + e.getMarginLeft();
                double y = e.getY() + e.getMarginTop() + borderTop + e.getPaddingTop() + e.getHeight() + e.getPaddingBottom();
                double w = borderLeft + e.getPaddingLeft() + e.getWidth() + e.getPaddingRight() + borderRight;
                ((CT_Path)((CT_Path)bottomBorder.setBoundary(x, y, w, bottomWidth)).setLineWidth(Double.valueOf(bottomWidth))).setAbbreviatedData(new AbbreviatedData().M(0.0, bottomWidth / 2.0).L(w, bottomWidth / 2.0));
                int[] borderColor = e.getBorderColor();
                if (borderColor != null) {
                    bottomBorder.setStrokeColor(CT_Color.rgb((int[])borderColor));
                }
                if (alpha != null) {
                    bottomBorder.setAlpha(alpha);
                }
                if (borderDash != null) {
                    DivRender.setLineDash(bottomBorder, borderDash);
                }
                layer.addPageBlock((PageBlockType)bottomBorder);
            }
            if (topWidth + bottomWidth + eleContentHeight == 0.0) {
                return;
            }
            double leftWidth = borderLeft;
            if (leftWidth > ZERO) {
                ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
                PathObject leftBorder = new PathObject(objId);
                double x = e.getX() + e.getMarginLeft();
                double y = e.getY() + e.getMarginTop() + topWidth;
                double h = borderTop + e.getPaddingTop() + e.getHeight() + e.getPaddingBottom() + borderBottom - topWidth - bottomWidth;
                ((CT_Path)((CT_Path)leftBorder.setBoundary(x, y, leftWidth, h)).setLineWidth(Double.valueOf(leftWidth))).setAbbreviatedData(new AbbreviatedData().M(leftWidth / 2.0, 0.0).L(leftWidth / 2.0, h));
                int[] borderColor = e.getBorderColor();
                if (borderColor != null) {
                    leftBorder.setStrokeColor(CT_Color.rgb((int[])borderColor));
                }
                if (alpha != null) {
                    leftBorder.setAlpha(alpha);
                }
                if (borderDash != null) {
                    DivRender.setLineDash(leftBorder, borderDash);
                }
                layer.addPageBlock((PageBlockType)leftBorder);
            }
            if ((rightWidth = borderRight.doubleValue()) > ZERO) {
                ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
                PathObject rightBorder = new PathObject(objId);
                double x = e.getX() + e.getMarginLeft() + borderLeft + e.getPaddingLeft() + e.getWidth() + e.getPaddingRight();
                double y = e.getY() + e.getMarginTop() + topWidth;
                double h = borderTop + e.getPaddingTop() + e.getHeight() + e.getPaddingBottom() + borderBottom - topWidth - bottomWidth;
                ((CT_Path)((CT_Path)rightBorder.setBoundary(x, y, rightWidth, h)).setLineWidth(Double.valueOf(rightWidth))).setAbbreviatedData(new AbbreviatedData().M(rightWidth / 2.0, 0.0).L(rightWidth / 2.0, h));
                int[] borderColor = e.getBorderColor();
                if (borderColor != null) {
                    rightBorder.setStrokeColor(CT_Color.rgb((int[])borderColor));
                }
                if (alpha != null) {
                    rightBorder.setAlpha(alpha);
                }
                if (borderDash != null) {
                    DivRender.setLineDash(rightBorder, borderDash);
                }
                layer.addPageBlock((PageBlockType)rightBorder);
            }
        }
    }

    private static void setLineDash(CT_GraphicUnit<?> g, Double[] dash) {
        if (dash == null || dash.length == 0 || dash.length == 1 && dash[0] == null) {
            return;
        }
        if (dash.length == 1) {
            dash = new Double[]{0.0, dash[0], dash[0]};
        }
        if (dash[0] != null && dash[0] >= 1.0E-6) {
            g.setDashOffset(dash[0]);
        }
        ST_Array dashPattern = new ST_Array(new Serializable[0]);
        for (int i = 1; i < dash.length; ++i) {
            dashPattern.add(STBase.fmt((double)dash[i]));
        }
        g.setDashPattern(dashPattern);
    }

    public static boolean eq(double ... arr) {
        if (arr == null || arr.length == 0) {
            return true;
        }
        String last = null;
        for (double v : arr) {
            String fmt = STBase.fmt((double)v);
            if (last == null) {
                last = fmt;
                continue;
            }
            if (last.equals(fmt)) continue;
            return false;
        }
        return true;
    }
}

