/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.pkg.container;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.signatures.sig.Signature;
import org.ofdrw.pkg.container.VirtualContainer;

public class SignDir
extends VirtualContainer {
    public static final String SignContainerPrefix = "Sign_";
    public static final String SealFileName = "Seal.esl";
    public static final String SignatureFileName = "Signature.xml";
    public static final String SignedValueFileName = "SignedValue.dat";
    private String index = this.getContainerName().replace("Sign_", "");

    public SignDir(Path fullDir) throws IllegalArgumentException {
        super(fullDir);
    }

    public Integer getIndex() {
        return Integer.parseInt(this.index);
    }

    public String getIndexStr() {
        return this.index;
    }

    public Signature getSignature() throws FileNotFoundException, DocumentException {
        Element ele = this.getObj(SignatureFileName);
        return new Signature(ele);
    }

    public SignDir setSignature(Signature signature) {
        this.putObj(SignatureFileName, (Element)signature);
        return this;
    }

    public Path getSeal() throws FileNotFoundException {
        return this.getFile(SealFileName);
    }

    public SignDir setSeal(Path seal) throws IOException {
        this.putFile(seal);
        return this;
    }

    public Path getSignedValue() throws FileNotFoundException {
        return this.getFile(SignedValueFileName);
    }

    public SignDir setSignedValue(Path signedValue) throws IOException {
        this.putFile(signedValue);
        return this;
    }
}

