/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKotlinCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKotlinCodegen.class);
    protected String artifactId;
    protected String artifactVersion = "1.0.0";
    protected String groupId = "org.openapitools";
    protected String packageName;
    protected String sourceFolder = "src/main/kotlin";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected CodegenConstants.ENUM_PROPERTY_NAMING_TYPE enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.camelCase;

    public AbstractKotlinCodegen() {
        this.supportsInheritance = true;
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("kotlin.Byte", "kotlin.ByteArray", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.String", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.Map", "kotlin.collections.Set"));
        this.reservedWords = new HashSet<String>(Arrays.asList("abstract", "annotation", "as", "break", "case", "catch", "class", "companion", "const", "constructor", "continue", "crossinline", "data", "delegate", "do", "else", "enum", "external", "false", "final", "finally", "for", "fun", "if", "in", "infix", "init", "inline", "inner", "interface", "internal", "is", "it", "lateinit", "lazy", "noinline", "null", "object", "open", "operator", "out", "override", "package", "private", "protected", "public", "reified", "return", "sealed", "super", "suspend", "tailrec", "this", "throw", "true", "try", "typealias", "typeof", "val", "var", "vararg", "when", "while"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("kotlin.Byte", "kotlin.ByteArray", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.Set", "kotlin.collections.Map"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "kotlin.String");
        this.typeMapping.put("boolean", "kotlin.Boolean");
        this.typeMapping.put("integer", "kotlin.Int");
        this.typeMapping.put("float", "kotlin.Float");
        this.typeMapping.put("long", "kotlin.Long");
        this.typeMapping.put("double", "kotlin.Double");
        this.typeMapping.put("ByteArray", "kotlin.ByteArray");
        this.typeMapping.put("number", "java.math.BigDecimal");
        this.typeMapping.put("date-time", "java.time.LocalDateTime");
        this.typeMapping.put("date", "java.time.LocalDateTime");
        this.typeMapping.put("file", "java.io.File");
        this.typeMapping.put("array", "kotlin.Array");
        this.typeMapping.put("list", "kotlin.collections.List");
        this.typeMapping.put("map", "kotlin.collections.Map");
        this.typeMapping.put("object", "kotlin.Any");
        this.typeMapping.put("binary", "kotlin.Array<kotlin.Byte>");
        this.typeMapping.put("Date", "java.time.LocalDateTime");
        this.typeMapping.put("DateTime", "java.time.LocalDateTime");
        this.instantiationTypes.put("array", "kotlin.arrayOf");
        this.instantiationTypes.put("list", "kotlin.arrayOf");
        this.instantiationTypes.put("map", "kotlin.mapOf");
        this.importMapping = new HashMap();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("DateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.specialCharReplacements.put(";", "Semicolon");
        this.cliOptions.clear();
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("packageName", "Generated artifact package name (e.g. io.swagger).", this.packageName);
        this.addOption("groupId", "Generated artifact package's organization (i.e. maven groupId).", this.groupId);
        this.addOption("artifactId", "Generated artifact id (name of jar).", this.artifactId);
        this.addOption("artifactVersion", "Generated artifact's package version.", this.artifactVersion);
        CliOption enumPropertyNamingOpt = new CliOption("enumPropertyNaming", "Naming convention for enum properties: 'camelCase', 'PascalCase', 'snake_case', 'UPPERCASE', and 'original'");
        this.cliOptions.add(enumPropertyNamingOpt.defaultValue(this.enumPropertyNaming.name()));
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeReservedWord(String name) {
        return String.format(Locale.ROOT, "`%s`", name);
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public CodegenConstants.ENUM_PROPERTY_NAMING_TYPE getEnumPropertyNaming() {
        return this.enumPropertyNaming;
    }

    public void setEnumPropertyNaming(String enumPropertyNamingType) {
        try {
            this.enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.valueOf(enumPropertyNamingType);
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(enumPropertyNamingType + " is an invalid enum property naming option. Please choose from:");
            for (CodegenConstants.ENUM_PROPERTY_NAMING_TYPE t : CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.values()) {
                sb.append("\n  ").append(t.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            return this.getArrayTypeDeclaration((ArraySchema)p);
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<kotlin.String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(super.postProcessModels(objs));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("enumPropertyNaming")) {
            this.setEnumPropertyNaming((String)this.additionalProperties.get("enumPropertyNaming"));
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
            if (!this.additionalProperties.containsKey("modelPackage")) {
                this.setModelPackage(this.packageName + ".models");
            }
            if (!this.additionalProperties.containsKey("apiPackage")) {
                this.setApiPackage(this.packageName + ".apis");
            }
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            LOGGER.warn("invokerPackage with " + this.getName() + " generator is ignored. Use " + "packageName" + ".");
        }
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        String modified;
        if (value.length() == 0) {
            modified = "EMPTY";
        } else {
            modified = value;
            modified = this.sanitizeKotlinSpecificNames(modified);
        }
        switch (this.getEnumPropertyNaming()) {
            case original: {
                modified = value;
                break;
            }
            case camelCase: {
                modified = StringUtils.camelize(modified, true);
                break;
            }
            case PascalCase: {
                String result = StringUtils.camelize(modified);
                modified = this.titleCase(result);
                break;
            }
            case snake_case: {
                modified = StringUtils.underscore(modified);
                break;
            }
            case UPPERCASE: {
                modified = modified.toUpperCase(Locale.ROOT);
            }
        }
        if (this.reservedWords.contains(modified)) {
            return this.escapeReservedWord(modified);
        }
        return this.sanitizeKotlinSpecificNames(modified);
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            return this.getArrayTypeDeclaration((ArraySchema)p);
        }
        return super.toInstantiationType(p);
    }

    @Override
    public String toModelImport(String name) {
        if (this.needToImport(name)) {
            return super.toModelImport(name);
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        if (name.startsWith("kotlin.") || name.startsWith("java.")) {
            return name;
        }
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        String modifiedName = name.replaceAll("\\.", "");
        modifiedName = this.sanitizeKotlinSpecificNames(modifiedName);
        if (this.isReservedWord(modifiedName = StringUtils.camelize(modifiedName))) {
            String modelName = "Model" + modifiedName;
            LOGGER.warn(modifiedName + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (modifiedName.matches("^\\d.*")) {
            String modelName = "Model" + modifiedName;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return this.titleCase(modifiedName);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = AbstractKotlinCodegen.camelize(this.sanitizeName(operationId), true))) {
            String newOperationId = AbstractKotlinCodegen.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method sname. Renamed to " + AbstractKotlinCodegen.camelize("call_" + operationId), (Object)true);
            operationId = AbstractKotlinCodegen.camelize("call_" + operationId, true);
        }
        return operationId;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    private String getArrayTypeDeclaration(ArraySchema arr) {
        String arrayType = (String)this.typeMapping.get("array");
        StringBuilder instantiationType = new StringBuilder(arrayType);
        Schema items = arr.getItems();
        String nestedType = this.getTypeDeclaration(items);
        instantiationType.append("<").append(nestedType).append(">");
        return instantiationType.toString();
    }

    private String sanitizeKotlinSpecificNames(String name) {
        String word = name;
        for (Map.Entry specialCharacters : this.specialCharReplacements.entrySet()) {
            if (((String)specialCharacters.getKey()).equals("_")) continue;
            word = word.replaceAll("\\Q" + (String)specialCharacters.getKey() + "\\E", (String)specialCharacters.getValue());
        }
        if ((word = word.replaceAll("\\W+", "_")).matches("\\d.*")) {
            word = "_" + word;
        }
        if (word.matches("^_*$")) {
            word = word.replaceAll("\\Q_\\E", "Underscore");
        }
        return word;
    }

    private String titleCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    @Override
    protected boolean needToImport(String type) {
        boolean imports = !type.startsWith("kotlin.") && !type.startsWith("java.") && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
        return imports;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("kotlin.Int".equals(datatype) || "kotlin.Long".equals(datatype)) {
            return value;
        }
        if ("kotlin.Double".equals(datatype)) {
            if (value.contains(".")) {
                return value;
            }
            return value + ".0";
        }
        if ("kotlin.Float".equals(datatype)) {
            return value + "f";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public boolean isDataTypeString(String dataType) {
        return "String".equals(dataType) || "kotlin.String".equals(dataType);
    }

    @Override
    public String toParamName(String name) {
        if ("callback".equals(name)) {
            return "paramCallback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name, "\\W-[\\$]")).toLowerCase(Locale.ROOT).matches("^_*class$")) {
            return "propertyClass";
        }
        if ("_".equals(name)) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.startsWithTwoUppercaseLetters(name)) {
            name = name.substring(0, 2).toLowerCase(Locale.ROOT) + name.substring(2);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.keySet().contains("" + (char)character))) {
            ArrayList<String> allowedCharacters = new ArrayList<String>();
            allowedCharacters.add("_");
            allowedCharacters.add("$");
            name = this.escapeSpecialCharacters(name, allowedCharacters, "_");
        }
        if (this.isReservedWord(name = AbstractKotlinCodegen.camelize(name, true)) || name.matches("(^\\d.*)|(.*[$].*)")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    private boolean startsWithTwoUppercaseLetters(String name) {
        boolean startsWithTwoUppercaseLetters = false;
        if (name.length() > 1) {
            startsWithTwoUppercaseLetters = name.substring(0, 2).equals(name.substring(0, 2).toUpperCase(Locale.ROOT));
        }
        return startsWithTwoUppercaseLetters;
    }
}

