/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.WeakHashMap;

public class Pipe {
    private static final int READ_BUF_SIZE = 8192;
    static final Map<InputStream, Pump> PUMPS = new WeakHashMap<InputStream, Pump>();
    private final InputStream m_in;
    private final OutputStream m_out;
    private Pump m_pump;

    public Pipe(InputStream processStream, OutputStream systemStream) {
        this.m_in = processStream;
        this.m_out = systemStream;
    }

    public Pipe(OutputStream processStream, InputStream systemStream) {
        this.m_in = systemStream;
        this.m_out = processStream;
    }

    public synchronized Pipe start(String name) {
        if (null == this.m_pump && null != this.m_in && null != this.m_out) {
            this.m_pump = Pipe.startPump(this.m_in);
            this.m_pump.setName(name);
            this.m_pump.connect(this.m_out);
        }
        return this;
    }

    public synchronized void stop() {
        if (null != this.m_pump) {
            this.m_pump.connect(null);
            this.m_pump.setName(this.m_pump.getName() + " (disconnected)");
            this.m_pump = null;
        }
    }

    static InputStream validate(InputStream is) {
        try {
            is.available();
            return is;
        }
        catch (Exception e) {
            return null;
        }
    }

    static OutputStream validate(OutputStream os) {
        try {
            os.flush();
            return os;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Pump startPump(InputStream is) {
        Map<InputStream, Pump> map = PUMPS;
        synchronized (map) {
            Pump pump = PUMPS.get(is);
            if (null == pump) {
                pump = new Pump(is);
                pump.setDaemon(true);
                pump.start();
                PUMPS.put(is, pump);
            }
            return pump;
        }
    }

    private static class Pump
    extends Thread {
        private final InputStream m_source;
        private OutputStream m_sink;

        public Pump(InputStream source) {
            this.m_source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect(OutputStream sink) {
            Pump pump = this;
            synchronized (pump) {
                this.m_sink = sink;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                byte[] byArray = new byte[8192];
                while (null != Pipe.validate(this.m_source)) {
                    int n = this.m_source.read(byArray);
                    if (n == -1) {
                        return;
                    }
                    Pump pump = this;
                    synchronized (pump) {
                        while (null == Pipe.validate(this.m_sink)) {
                            this.wait();
                        }
                        this.m_sink.write(byArray, 0, n);
                        this.m_sink.flush();
                    }
                }
                return;
            }
            catch (IOException iOException) {
                if (null == this.m_sink) return;
                iOException.printStackTrace();
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                Map<InputStream, Pump> map = PUMPS;
                synchronized (map) {
                    if (PUMPS.get(this.m_source) == this) {
                        PUMPS.remove(this.m_source);
                    }
                }
            }
        }
    }
}

