/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.NvdCveInfo;
import org.owasp.dependencycheck.data.update.nvd.ProcessTask;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ExtractionUtil;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DownloadTask
implements Callable<Future<ProcessTask>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadTask.class);
    private final CveDB cveDB;
    private final ExecutorService processorService;
    private NvdCveInfo nvdCveInfo;
    private final Settings settings;
    private File first;
    private File second;

    public DownloadTask(NvdCveInfo nvdCveInfo, ExecutorService processor, CveDB cveDB, Settings settings) throws UpdateException {
        File file2;
        File file1;
        this.nvdCveInfo = nvdCveInfo;
        this.processorService = processor;
        this.cveDB = cveDB;
        this.settings = settings;
        try {
            file1 = File.createTempFile("cve" + nvdCveInfo.getId() + '_', ".xml", settings.getTempDirectory());
            file2 = File.createTempFile("cve_1_2_" + nvdCveInfo.getId() + '_', ".xml", settings.getTempDirectory());
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to create temporary files", ex);
        }
        this.first = file1;
        this.second = file2;
    }

    public NvdCveInfo getNvdCveInfo() {
        return this.nvdCveInfo;
    }

    public void setNvdCveInfo(NvdCveInfo nvdCveInfo) {
        this.nvdCveInfo = nvdCveInfo;
    }

    public File getFirst() {
        return this.first;
    }

    public File getSecond() {
        return this.second;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<ProcessTask> call() throws Exception {
        try {
            URL url1 = new URL(this.nvdCveInfo.getUrl());
            URL url2 = new URL(this.nvdCveInfo.getOldSchemaVersionUrl());
            LOGGER.info("Download Started for NVD CVE - {}", (Object)this.nvdCveInfo.getId());
            long startDownload = System.currentTimeMillis();
            try {
                Downloader downloader = new Downloader(this.settings);
                downloader.fetchFile(url1, this.first);
                downloader.fetchFile(url2, this.second);
            }
            catch (DownloadFailedException ex) {
                LOGGER.warn("Download Failed for NVD CVE - {}\nSome CVEs may not be reported.", (Object)this.nvdCveInfo.getId());
                if (this.settings.getString("proxy.server") == null) {
                    LOGGER.info("If you are behind a proxy you may need to configure dependency-check to use the proxy.");
                }
                LOGGER.debug("", (Throwable)ex);
                Future<ProcessTask> future = null;
                this.settings.cleanup(false);
                return future;
            }
            if (url1.toExternalForm().endsWith(".xml.gz") && !DownloadTask.isXml(this.first)) {
                ExtractionUtil.extractGzip(this.first);
            }
            if (url2.toExternalForm().endsWith(".xml.gz") && !DownloadTask.isXml(this.second)) {
                ExtractionUtil.extractGzip(this.second);
            }
            if (url1.toExternalForm().endsWith(".xml.zip") && !DownloadTask.isXml(this.first)) {
                ExtractionUtil.extractZip(this.first);
            }
            if (url2.toExternalForm().endsWith(".xml.zip") && !DownloadTask.isXml(this.second)) {
                ExtractionUtil.extractZip(this.second);
            }
            LOGGER.info("Download Complete for NVD CVE - {}  ({} ms)", (Object)this.nvdCveInfo.getId(), (Object)(System.currentTimeMillis() - startDownload));
            if (this.processorService == null) {
                Future<ProcessTask> ex = null;
                return ex;
            }
            ProcessTask task = new ProcessTask(this.cveDB, this, this.settings);
            Future<ProcessTask> future = this.processorService.submit(task);
            return future;
        }
        catch (Throwable ex) {
            LOGGER.warn("An exception occurred downloading NVD CVE - {}\nSome CVEs may not be reported.", (Object)this.nvdCveInfo.getId());
            LOGGER.debug("Download Task Failed", ex);
        }
        finally {
            this.settings.cleanup(false);
        }
        return null;
    }

    public void cleanup() {
        if (this.first != null && this.first.exists() && !this.first.delete()) {
            LOGGER.debug("Failed to delete first temporary file {}", (Object)this.first.toString());
            this.first.deleteOnExit();
        }
        if (this.second != null && this.second.exists() && !this.second.delete()) {
            LOGGER.debug("Failed to delete second temporary file {}", (Object)this.second.toString());
            this.second.deleteOnExit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isXml(File file) {
        if (file == null) return false;
        if (!file.isFile()) {
            return false;
        }
        try (FileInputStream is = new FileInputStream(file);){
            byte[] buf = new byte[5];
            int read = ((InputStream)is).read(buf);
            boolean bl = !(read != 5 || buf[0] != 60 || buf[1] != 63 || buf[2] != 120 && buf[2] != 88 || buf[3] != 109 && buf[3] != 77 || buf[4] != 108 && buf[4] != 76);
            return bl;
        }
        catch (IOException ex) {
            LOGGER.debug("Error checking if file is xml", (Throwable)ex);
            return false;
        }
    }
}

