/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.pac4j.core.util.CommonHelper;

public final class HttpUtils {
    private static int connectTimeout = 500;
    private static int readTimeout = 5000;

    private HttpUtils() {
    }

    public static String buildHttpErrorMessage(HttpURLConnection connection) throws IOException {
        StringBuilder messageBuilder = new StringBuilder("(").append(connection.getResponseCode()).append(")");
        if (connection.getResponseMessage() != null) {
            messageBuilder.append(" ");
            messageBuilder.append(connection.getResponseMessage());
        }
        return messageBuilder.toString();
    }

    public static HttpURLConnection openPostConnection(URL url) throws IOException {
        return HttpUtils.openConnection(url, "POST");
    }

    public static HttpURLConnection openDeleteConnection(URL url) throws IOException {
        return HttpUtils.openConnection(url, "DELETE");
    }

    public static HttpURLConnection openConnection(URL url, String requestMethod) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod(requestMethod);
        connection.setConnectTimeout(connectTimeout);
        connection.setReadTimeout(readTimeout);
        return connection;
    }

    public static String encodeQueryParam(String paramName, String paramValue) throws UnsupportedEncodingException {
        return CommonHelper.urlEncode((String)paramName) + "=" + CommonHelper.urlEncode((String)paramValue);
    }

    public static void closeConnection(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    public static int getConnectTimeout() {
        return connectTimeout;
    }

    public static void setConnectTimeout(int connectTimeout) {
        HttpUtils.connectTimeout = connectTimeout;
    }

    public static int getReadTimeout() {
        return readTimeout;
    }

    public static void setReadTimeout(int readTimeout) {
        HttpUtils.readTimeout = readTimeout;
    }
}

