/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;

public class FromAttributesAuthorizationGenerator<U extends CommonProfile>
implements AuthorizationGenerator<U> {
    private final String[] roleAttributes;
    private final String[] permissionAttributes;
    private String splitChar = ",";

    public FromAttributesAuthorizationGenerator(String[] roleAttributes, String[] permissionAttributes) {
        this.roleAttributes = this.copyArray(roleAttributes);
        this.permissionAttributes = this.copyArray(permissionAttributes);
    }

    private String[] copyArray(String[] original) {
        if (original != null) {
            return Arrays.copyOf(original, original.length);
        }
        return null;
    }

    @Override
    public void generate(U profile) {
        this.generateAuth(profile, this.roleAttributes, true);
        this.generateAuth(profile, this.permissionAttributes, false);
    }

    private void generateAuth(U profile, String[] attributes, boolean isRole) {
        if (attributes != null) {
            for (String attribute : attributes) {
                Object value = ((UserProfile)profile).getAttribute(attribute);
                if (value == null) continue;
                if (value instanceof String) {
                    StringTokenizer st = new StringTokenizer((String)value, this.splitChar);
                    while (st.hasMoreTokens()) {
                        this.setAuth(profile, st.nextToken(), isRole);
                    }
                    continue;
                }
                if (value.getClass().isArray() && value.getClass().getComponentType().isAssignableFrom(String.class)) {
                    for (Object item : (Object[])value) {
                        this.setAuth(profile, item.toString(), isRole);
                    }
                    continue;
                }
                if (!Collection.class.isAssignableFrom(value.getClass())) continue;
                for (Object item : (Collection)value) {
                    if (!item.getClass().isAssignableFrom(String.class)) continue;
                    this.setAuth(profile, item.toString(), isRole);
                }
            }
        }
    }

    private void setAuth(U profile, String value, boolean isRole) {
        if (isRole) {
            ((UserProfile)profile).addRole(value);
        } else {
            ((UserProfile)profile).addPermission(value);
        }
    }

    public String getSplitChar() {
        return this.splitChar;
    }

    public void setSplitChar(String splitChar) {
        this.splitChar = splitChar;
    }
}

