/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import java.util.function.Function;
import java.util.regex.Pattern;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.ApplicationLogoutLogic;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.HttpActionAdapter;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationLogoutLogic<R, C extends WebContext>
implements ApplicationLogoutLogic<R, C> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Function<C, ProfileManager> profileManagerFactory = context -> new ProfileManager((WebContext)context);
    private boolean killSession;

    @Override
    public R perform(C context, Config config, HttpActionAdapter<R, C> httpActionAdapter, String defaultUrl, String inputLogoutUrlPattern) {
        this.logger.debug("=== APP LOGOUT ===");
        String logoutUrlPattern = inputLogoutUrlPattern == null ? "/.*" : inputLogoutUrlPattern;
        CommonHelper.assertNotNull("context", context);
        CommonHelper.assertNotNull("config", config);
        CommonHelper.assertNotNull("httpActionAdapter", httpActionAdapter);
        CommonHelper.assertNotBlank("logoutUrlPattern", logoutUrlPattern);
        ProfileManager manager = this.getProfileManager(context);
        manager.logout();
        this.postLogout(context);
        String url = context.getRequestParameter("url");
        String redirectUrl = defaultUrl;
        if (url != null && Pattern.matches(logoutUrlPattern, url)) {
            redirectUrl = url;
        }
        this.logger.debug("redirectUrl: {}", (Object)redirectUrl);
        HttpAction action = redirectUrl != null ? HttpAction.redirect("redirect", context, redirectUrl) : HttpAction.ok("ok", context);
        return httpActionAdapter.adapt(action.getCode(), context);
    }

    protected void postLogout(C context) {
        if (this.killSession) {
            context.invalidationSession();
        }
    }

    protected ProfileManager getProfileManager(C context) {
        return this.profileManagerFactory.apply(context);
    }

    public boolean isKillSession() {
        return this.killSession;
    }

    public void setKillSession(boolean killSession) {
        this.killSession = killSession;
    }

    public Function<C, ProfileManager> getProfileManagerFactory() {
        return this.profileManagerFactory;
    }

    public void setProfileManagerFactory(Function<C, ProfileManager> factory) {
        this.profileManagerFactory = factory;
    }
}

