/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import java.util.Date;
import java.util.Locale;
import org.pac4j.core.kryo.LocaleSerializer;
import org.pac4j.core.profile.FormattedDate;

public class FormattedDateSerializer
extends Serializer<FormattedDate> {
    private final DefaultSerializers.LongSerializer longSerializer = new DefaultSerializers.LongSerializer();
    private final DefaultSerializers.StringSerializer stringSerializer = new DefaultSerializers.StringSerializer();
    private final LocaleSerializer localeSerializer = new LocaleSerializer();

    public FormattedDate read(Kryo kryo, Input input, Class<FormattedDate> aClass) {
        Long time = this.longSerializer.read(kryo, input, Long.class);
        String format = this.stringSerializer.read(kryo, input, String.class);
        Object locale = this.localeSerializer.read(kryo, input, (Class)Locale.class);
        return new FormattedDate(new Date(time), format, (Locale)locale);
    }

    public void write(Kryo kryo, Output output, FormattedDate formattedDate) {
        this.longSerializer.write(kryo, output, Long.valueOf(formattedDate.getTime()));
        this.stringSerializer.write(kryo, output, formattedDate.getFormat());
        this.localeSerializer.write(kryo, output, formattedDate.getLocale());
    }
}

