/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.AnonymousProfile;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProfileHelper {
    private static final Logger logger = LoggerFactory.getLogger(ProfileHelper.class);
    private static final Map<String, Constructor<? extends CommonProfile>> constructorsCache = new ConcurrentHashMap<String, Constructor<? extends CommonProfile>>();

    public static boolean isTypedIdOf(String id, Class<? extends CommonProfile> clazz) {
        if (id != null && clazz != null) {
            boolean typedId = id.startsWith(clazz.getName() + "#");
            boolean oldTypedId = id.startsWith(clazz.getSimpleName() + "#");
            return typedId || oldTypedId;
        }
        return false;
    }

    public static CommonProfile buildProfile(String typedId, Map<String, Object> attributes) {
        if (CommonHelper.isBlank(typedId)) {
            return null;
        }
        logger.info("Building user profile based on typedId {}", (Object)typedId);
        try {
            String className;
            String[] values = typedId.split("#");
            if (values != null && values.length >= 1 && CommonHelper.isNotBlank(className = values[0])) {
                String completeName;
                if (className.indexOf(".") >= 0) {
                    completeName = className;
                } else {
                    logger.warn("Typed identifier starting with only a simple class name (without package name) are deprecated and will be removed in future versions. See profile#getOldTypedId() versus profile#getTypedId()");
                    completeName = ProfileHelper.determineProfileClassByName(className);
                }
                CommonProfile profile = ProfileHelper.buildUserProfileByClassCompleteName(completeName);
                profile.build(typedId, attributes);
                logger.debug("userProfile built: {}", (Object)profile);
                return profile;
            }
        }
        catch (TechnicalException e) {
            logger.error("Cannot build instance", (Throwable)e);
        }
        return null;
    }

    @Deprecated
    private static String determineProfileClassByName(String className) {
        String completeName;
        if ("CasProfile".equals(className) || "CasProxyProfile".equals(className)) {
            completeName = "org.pac4j.cas.profile." + className;
        } else if ("HttpTGTProfile".equals(className)) {
            completeName = "org.pac4j.cas.profile.HttpTGTProfile";
        } else if ("SAML2Profile".equals(className)) {
            completeName = "org.pac4j.saml.profile.SAML2Profile";
        } else if ("HttpProfile".equals(className)) {
            completeName = "org.pac4j.http.profile.HttpProfile";
        } else if ("OidcProfile".equals(className)) {
            completeName = "org.pac4j.oidc.profile.OidcProfile";
        } else if ("LdapProfile".equals(className)) {
            completeName = "org.pac4j.ldap.profile.LdapProfile";
        } else if ("DbProfile".equals(className)) {
            completeName = "org.pac4j.sql.profile.DbProfile";
        } else if ("MongoProfile".equals(className)) {
            completeName = "org.pac4j.mongo.profile.MongoProfile";
        } else if ("YahooOpenIdProfile".equals(className)) {
            completeName = "org.pac4j.openid.profile.yahoo.YahooOpenIdProfile";
        } else if ("GaeUserServiceProfile".equals(className)) {
            completeName = "org.pac4j.gae.profile.GaeUserServiceProfile";
        } else if ("StormpathProfile".equals(className)) {
            completeName = "org.pac4j.stormpath.profile.StormpathProfile";
        } else if ("JwtProfile".equals(className)) {
            completeName = "org.pac4j.jwt.profile.JwtProfile";
        } else {
            String packageName = className.substring(0, className.length() - 7).toLowerCase();
            completeName = "org.pac4j.oauth.profile." + packageName + '.' + className;
        }
        return completeName;
    }

    public static CommonProfile buildUserProfileByClassCompleteName(String completeName) {
        try {
            Constructor<? extends CommonProfile> constructor = ProfileHelper.getConstructor(completeName);
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TechnicalException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Constructor<? extends CommonProfile> getConstructor(String name) throws ClassNotFoundException, NoSuchMethodException {
        Constructor<CommonProfile> constructor = constructorsCache.get(name);
        if (constructor == null) {
            Map<String, Constructor<? extends CommonProfile>> map = constructorsCache;
            synchronized (map) {
                constructor = constructorsCache.get(name);
                if (constructor == null) {
                    ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                    constructor = tccl == null ? Class.forName(name).getDeclaredConstructor(new Class[0]) : Class.forName(name, true, tccl).getDeclaredConstructor(new Class[0]);
                    constructorsCache.put(name, constructor);
                }
            }
        }
        return constructor;
    }

    public static <U extends CommonProfile> Optional<U> flatIntoOneProfile(LinkedHashMap<String, U> profiles) {
        if (profiles.size() == 0) {
            return Optional.empty();
        }
        CommonProfile profile = null;
        for (CommonProfile nextProfile : profiles.values()) {
            if (profile != null && !(profile instanceof AnonymousProfile)) continue;
            profile = nextProfile;
        }
        return Optional.of(profile);
    }

    public static <U extends CommonProfile> List<U> flatIntoAProfileList(LinkedHashMap<String, U> profiles) {
        ArrayList<U> listProfiles = new ArrayList<U>();
        for (Map.Entry<String, U> entry : profiles.entrySet()) {
            listProfiles.add(entry.getValue());
        }
        return Collections.unmodifiableList(listProfiles);
    }
}

