/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile.converter;

import org.pac4j.core.profile.Color;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColorConverter
implements AttributeConverter<Color> {
    private static final Logger logger = LoggerFactory.getLogger(ColorConverter.class);

    @Override
    public Color convert(Object attribute) {
        if (attribute != null) {
            if (attribute instanceof String) {
                String s = (String)attribute;
                if (s.length() == 6) {
                    try {
                        String hex = s.substring(0, 2);
                        int r = Integer.parseInt(hex, 16);
                        hex = s.substring(2, 4);
                        int g = Integer.parseInt(hex, 16);
                        hex = s.substring(4, 6);
                        int b = Integer.parseInt(hex, 16);
                        return new Color(r, g, b);
                    }
                    catch (NumberFormatException e) {
                        logger.error("Cannot convert " + s + " into color", (Throwable)e);
                    }
                }
            } else if (attribute instanceof Color) {
                return (Color)attribute;
            }
        }
        return null;
    }
}

