/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateConverter
implements AttributeConverter<Date> {
    protected static final Logger logger = LoggerFactory.getLogger(DateConverter.class);
    protected String format;
    protected Locale locale;

    public DateConverter(String format) {
        this.format = format;
    }

    public DateConverter(String format, Locale locale) {
        this.format = format;
        this.locale = locale;
    }

    @Override
    public Date convert(Object attribute) {
        if (attribute != null) {
            if (attribute instanceof String) {
                SimpleDateFormat simpleDateFormat = this.locale == null ? new SimpleDateFormat(this.format) : new SimpleDateFormat(this.format, this.locale);
                String s = (String)attribute;
                try {
                    return simpleDateFormat.parse(s);
                }
                catch (ParseException e) {
                    logger.error("parse exception on " + s + " with format : " + this.format, (Throwable)e);
                }
            } else if (attribute instanceof Date) {
                return (Date)attribute;
            }
        }
        return null;
    }
}

