/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.indirect;

import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.credentials.authenticator.Authenticator;
import org.pac4j.http.credentials.extractor.Extractor;
import org.pac4j.http.profile.HttpProfile;
import org.pac4j.http.profile.creator.AuthenticatorProfileCreator;
import org.pac4j.http.profile.creator.ProfileCreator;

public abstract class IndirectHttpClient<C extends Credentials>
extends IndirectClient<C, HttpProfile> {
    protected Extractor<UsernamePasswordCredentials> extractor;
    private Authenticator<C> authenticator;
    private ProfileCreator<C, HttpProfile> profileCreator = AuthenticatorProfileCreator.INSTANCE;

    public IndirectHttpClient<C> clone() {
        IndirectHttpClient newClient = (IndirectHttpClient)super.clone();
        newClient.setCallbackUrl(this.callbackUrl);
        newClient.setAuthenticator(this.authenticator);
        newClient.setProfileCreator(this.profileCreator);
        return newClient;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"extractor", this.extractor);
        CommonHelper.assertNotNull((String)"authenticator", this.getAuthenticator());
        CommonHelper.assertNotNull((String)"profileCreator", this.getProfileCreator());
    }

    protected HttpProfile retrieveUserProfile(C credentials, WebContext context) {
        HttpProfile profile = this.getProfileCreator().create(credentials);
        this.logger.debug("profile: {}", (Object)profile);
        return profile;
    }

    public Authenticator<C> getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator<C> authenticator) {
        this.authenticator = authenticator;
    }

    public ProfileCreator<C, HttpProfile> getProfileCreator() {
        return this.profileCreator;
    }

    public void setProfileCreator(ProfileCreator<C, HttpProfile> profileCreator) {
        this.profileCreator = profileCreator;
    }
}

