/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.credentials.authenticator;

import java.util.ArrayList;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.Conditions;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.profile.SAML2Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SAML2Authenticator
extends ProfileDefinitionAware<SAML2Profile>
implements Authenticator<SAML2Credentials> {
    public static final String SAML_CONDITION_NOT_BEFORE_ATTRIBUTE = "notBefore";
    public static final String SAML_CONDITION_NOT_ON_OR_AFTER_ATTRIBUTE = "notOnOrAfter";
    public static final String SESSION_INDEX = "sessionindex";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void internalInit(WebContext context) {
        this.defaultProfileDefinition((ProfileDefinition)new CommonProfileDefinition(x -> new SAML2Profile()));
    }

    public void validate(SAML2Credentials credentials, WebContext context) throws HttpAction, CredentialsException {
        this.init(context);
        SAML2Profile profile = (SAML2Profile)this.getProfileDefinition().newProfile(new Object[0]);
        profile.setId(credentials.getNameId().getValue());
        profile.addAttribute(SESSION_INDEX, credentials.getSessionIndex());
        for (Attribute attribute : credentials.getAttributes()) {
            this.logger.debug("Processing profile attribute {}", (Object)attribute);
            String name = attribute.getName();
            String friendlyName = attribute.getFriendlyName();
            ArrayList<String> values = new ArrayList<String>();
            for (XMLObject attributeValue : attribute.getAttributeValues()) {
                Element attributeValueElement = attributeValue.getDOM();
                if (attributeValueElement != null) {
                    String value = attributeValueElement.getTextContent();
                    this.logger.debug("Adding attribute value {} for attribute {} / {}", new Object[]{value, name, friendlyName});
                    values.add(value);
                    continue;
                }
                this.logger.warn("Attribute value DOM element is null for {}", (Object)attribute);
            }
            if (!values.isEmpty()) {
                this.getProfileDefinition().convertAndAdd((CommonProfile)profile, name, values);
                if (!CommonHelper.isNotBlank((String)friendlyName)) continue;
                this.getProfileDefinition().convertAndAdd((CommonProfile)profile, friendlyName, values);
                continue;
            }
            this.logger.debug("No attribute values found for {}", (Object)name);
        }
        Conditions conditions = credentials.getConditions();
        if (conditions != null) {
            profile.addAttribute(SAML_CONDITION_NOT_BEFORE_ATTRIBUTE, conditions.getNotBefore());
            profile.addAttribute(SAML_CONDITION_NOT_ON_OR_AFTER_ATTRIBUTE, conditions.getNotOnOrAfter());
        }
        credentials.setUserProfile(profile);
    }
}

