/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.SecurityException;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataSigner;

public class DefaultSAML2MetadataSigner
implements SAML2MetadataSigner {
    protected final CredentialProvider credentialProvider;
    protected final String signatureAlgorithm;
    protected final String signatureReferenceDigestMethod;

    public DefaultSAML2MetadataSigner(CredentialProvider credentialProvider, String signatureAlgorithm, String signatureReferenceDigestMethod) {
        this.credentialProvider = credentialProvider;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureReferenceDigestMethod = signatureReferenceDigestMethod;
    }

    @Override
    public void sign(EntityDescriptor descriptor) {
        SignatureSigningParameters signingParameters = new SignatureSigningParameters();
        signingParameters.setKeyInfoGenerator(this.credentialProvider.getKeyInfoGenerator());
        signingParameters.setSigningCredential(this.credentialProvider.getCredential());
        signingParameters.setSignatureAlgorithm(this.signatureAlgorithm);
        signingParameters.setSignatureReferenceDigestMethod(this.signatureReferenceDigestMethod);
        signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        try {
            SignatureSupport.signObject((SignableXMLObject)descriptor, (SignatureSigningParameters)signingParameters);
        }
        catch (MarshallingException | SecurityException | SignatureException e) {
            throw new SAMLException(e.getMessage(), e);
        }
    }
}

