/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.util;

import java.time.Duration;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.pac4j.core.exception.TechnicalException;

public class SAML2HttpClientBuilder {
    private Duration connectionTimeout;
    private Duration socketTimeout;
    private boolean useSystemProperties;
    private boolean followRedirects;
    private boolean closeConnectionAfterResponse = true;
    private int maxConnectionsTotal = 3;
    private CredentialsProvider credentialsProvider;

    public HttpClient build() {
        try {
            Pac4jHttpClientBuilder builder = new Pac4jHttpClientBuilder();
            builder.resetDefaults();
            if (this.connectionTimeout != null) {
                builder.setConnectionTimeout(this.connectionTimeout);
            }
            builder.setUseSystemProperties(this.useSystemProperties);
            if (this.socketTimeout != null) {
                builder.setSocketTimeout(this.socketTimeout);
            }
            builder.setHttpFollowRedirects(this.followRedirects);
            builder.setMaxConnectionsTotal(this.maxConnectionsTotal);
            builder.setConnectionCloseAfterResponse(this.closeConnectionAfterResponse);
            if (this.credentialsProvider != null) {
                builder.getApacheBuilder().setDefaultCredentialsProvider(this.credentialsProvider);
            }
            return builder.buildClient();
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Duration socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isUseSystemProperties() {
        return this.useSystemProperties;
    }

    public void setUseSystemProperties(boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean isCloseConnectionAfterResponse() {
        return this.closeConnectionAfterResponse;
    }

    public void setCloseConnectionAfterResponse(boolean closeConnectionAfterResponse) {
        this.closeConnectionAfterResponse = closeConnectionAfterResponse;
    }

    public int getMaxConnectionsTotal() {
        return this.maxConnectionsTotal;
    }

    public void setMaxConnectionsTotal(int maxConnectionsTotal) {
        this.maxConnectionsTotal = maxConnectionsTotal;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    private static class Pac4jHttpClientBuilder
    extends HttpClientBuilder {
        private Pac4jHttpClientBuilder() {
        }

        protected org.apache.http.impl.client.HttpClientBuilder getApacheBuilder() {
            org.apache.http.impl.client.HttpClientBuilder builder = super.getApacheBuilder();
            return builder;
        }
    }
}

