/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.errors;

import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.ParseError;

public class BasicParseError
implements ParseError {
    private final InputBuffer inputBuffer;
    private final int startIndex;
    private final String errorMessage;
    private int endIndex;
    private int indexDelta;

    public BasicParseError(InputBuffer inputBuffer, int n, String string) {
        this.inputBuffer = Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        this.startIndex = n;
        this.endIndex = n + 1;
        this.errorMessage = string;
    }

    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public int getStartIndex() {
        return this.startIndex + this.indexDelta;
    }

    public int getEndIndex() {
        return this.endIndex + this.indexDelta;
    }

    public void setEndIndex(int n) {
        this.endIndex = n - this.indexDelta;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getIndexDelta() {
        return this.indexDelta;
    }

    public void shiftIndexDeltaBy(int n) {
        this.indexDelta += n;
    }
}

