/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import java.util.ArrayList;
import java.util.List;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.matchervisitors.IsSingleCharMatcherVisitor;
import org.parboiled.parserunners.AbstractParseRunner;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorReportingParseRunner<V>
extends AbstractParseRunner<V>
implements MatchHandler {
    private final IsSingleCharMatcherVisitor isSingleCharMatcherVisitor = new IsSingleCharMatcherVisitor();
    private final int errorIndex;
    private final MatchHandler inner;
    private final List<MatcherPath> failedMatchers = new ArrayList<MatcherPath>();
    private boolean seeking;

    public ErrorReportingParseRunner(Rule rule, int n) {
        this(rule, n, null);
    }

    public ErrorReportingParseRunner(Rule rule, int n, MatchHandler matchHandler) {
        super(rule);
        this.errorIndex = n;
        this.inner = matchHandler;
    }

    @Override
    public ParsingResult<V> run(InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        this.resetValueStack();
        this.failedMatchers.clear();
        this.seeking = this.errorIndex > 0;
        MatcherContext matcherContext = this.createRootContext(inputBuffer, this, false);
        boolean bl = this.match(matcherContext);
        if (!bl) {
            this.getParseErrors().add(new InvalidInputError(inputBuffer, this.errorIndex, this.failedMatchers, null));
        }
        return this.createParsingResult(bl, matcherContext);
    }

    @Override
    public boolean match(MatcherContext<?> matcherContext) {
        boolean bl;
        boolean bl2 = bl = this.inner == null && matcherContext.getMatcher().match(matcherContext) || this.inner != null && this.inner.match(matcherContext);
        if (matcherContext.getCurrentIndex() == this.errorIndex) {
            if (bl && this.seeking) {
                this.seeking = false;
            }
            if (!bl && !this.seeking && matcherContext.getMatcher().accept(this.isSingleCharMatcherVisitor).booleanValue()) {
                this.failedMatchers.add(matcherContext.getPath());
            }
        }
        return bl;
    }
}

