/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven.utils;

import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public class ScopeDependencySelector
implements DependencySelector {
    private final String[] scopes;
    private final int depth;
    private final Dependency parent;
    private final ScopeDependencySelector parentSelector;

    public ScopeDependencySelector(String ... scopes) {
        this(scopes, null, null, 0);
    }

    protected ScopeDependencySelector(String[] scopes, Dependency parent, ScopeDependencySelector parentSelector, int depth) {
        this.scopes = scopes;
        this.parent = parent;
        this.parentSelector = parentSelector;
        this.depth = depth;
    }

    private boolean hasRequiredScope(Dependency dep) {
        String scope = dep.getScope();
        if (scope == null || scope.isEmpty()) {
            scope = "compile";
        }
        for (String s : this.scopes) {
            if (!s.equals(scope)) continue;
            return true;
        }
        return false;
    }

    public boolean selectDependency(Dependency dependency) {
        if (!this.isExcluded(dependency)) {
            boolean optional = dependency.isOptional();
            return !optional && this.hasRequiredScope(dependency);
        }
        return false;
    }

    protected boolean isExcluded(Dependency dependency) {
        boolean result = this.isExcludedFromParent(dependency);
        if (!result && this.parentSelector != null) {
            result = this.parentSelector.isExcluded(dependency);
        }
        return result;
    }

    private boolean isExcludedFromParent(Dependency dependency) {
        boolean result = false;
        if (this.parent != null && this.parent.getExclusions().size() > 0) {
            for (Exclusion exclusion : this.parent.getExclusions()) {
                if (exclusion == null || exclusion.getArtifactId() == null || !exclusion.getArtifactId().equals(dependency.getArtifact().getArtifactId()) || exclusion.getGroupId() == null || !exclusion.getGroupId().equals(dependency.getArtifact().getGroupId())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        return new ScopeDependencySelector(this.scopes, context.getDependency(), this, this.depth + 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScopeDependencySelector that = (ScopeDependencySelector)obj;
        return this.depth == that.depth;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.depth;
        return hash;
    }
}

