/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Map;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebElementHandler;

public class ElementEquality
extends WebElementHandler<Boolean> {
    private volatile String otherId;

    public ElementEquality(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        super.setJsonParameters(allParameters);
        this.otherId = (String)allParameters.get("other");
    }

    @Override
    public Boolean call() {
        WebElement one = this.getElement();
        WebElement two = this.getKnownElements().get(this.otherId);
        if (one instanceof WrapsElement) {
            one = ((WrapsElement)one).getWrappedElement();
        }
        if (two instanceof KnownElements.ProxiedElement) {
            two = ((KnownElements.ProxiedElement)two).getWrappedElement();
        }
        return one.equals(two);
    }

    public String toString() {
        return String.format("[equals: %s, %s]", this.getElementAsString(), this.otherId);
    }
}

