/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.interactions.touch;

import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebElementHandler;
import org.openqa.selenium.remote.server.handler.interactions.HasTouchScreen;
import org.openqa.selenium.remote.server.handler.interactions.TouchScreen;

public class Scroll
extends WebElementHandler<Void> {
    private static final String ELEMENT = "element";
    private static final String XOFFSET = "xoffset";
    private static final String YOFFSET = "yoffset";
    String elementId;
    int xOffset;
    int yOffset;

    public Scroll(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        super.setJsonParameters(allParameters);
        if (allParameters.containsKey(ELEMENT)) {
            this.elementId = (String)allParameters.get(ELEMENT);
        }
        try {
            this.xOffset = ((Number)allParameters.get(XOFFSET)).intValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-numeric) x offset value for touch scroll passed: " + allParameters.get(XOFFSET), (Throwable)ex);
        }
        try {
            this.yOffset = ((Number)allParameters.get(YOFFSET)).intValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-numeric) y offset value for touch scroll passed: " + allParameters.get(YOFFSET), (Throwable)ex);
        }
    }

    @Override
    public Void call() {
        TouchScreen touchScreen = ((HasTouchScreen)this.getDriver()).getTouch();
        if (this.elementId != null) {
            WebElement element = this.getKnownElements().get(this.elementId);
            Coordinates elementLocation = ((Locatable)element).getCoordinates();
            touchScreen.scroll(elementLocation, this.xOffset, this.yOffset);
        } else {
            touchScreen.scroll(this.xOffset, this.yOffset);
        }
        return null;
    }

    public String toString() {
        return String.format("[scroll: %s]", this.elementId);
    }
}

